<?php

use CodeIgniter\Router\RouteCollection;

/**
 * @var RouteCollection $routes
 */
//navigation
$routes->get('/', 'Home::index');
$routes->get('login', 'Home::login');

//session
$routes->post('login/acceso', 'Home::signin');
$routes->get('logout', 'Home::logout');

//dashboard
$routes->get('/dashboard', 'DashboardController::index');

//clientes
$routes->get('/customer/create_customer_view', 'Customer\CustomerController::create_customer_view');
$routes->get('/customer/customer_dashboard', 'Customer\CustomerController::customer_dashboard');

//shipment
$routes->get('/shipment/new_shipment', 'Shipment\ShipmentController::new_shipment');

//contacts
$routes->group('crm', function ($routes) {
    // CONTACTS
    $routes->get('contacts', 'Crm\ContactsController::index');
    $routes->get('contacts/create', 'Crm\ContactsController::create');
    $routes->get('contacts/(:num)/quotes', 'Crm\QuotesController::listByContact/$1');
    $routes->get('contacts/view/(:num)', 'Crm\ContactsController::view/$1');
    $routes->get('contacts/edit/(:num)', 'Crm\ContactsController::edit/$1');
    $routes->post('contacts/update/(:num)', 'Crm\ContactsController::update/$1');
    $routes->post('contacts/store', 'Crm\ContactsController::store');
    // QUOTES
    $routes->get('quotes', 'Crm\QuotesController::index');
    $routes->get('quotes/create/(:num)', 'Crm\QuotesController::create/$1');
    $routes->get('quotes/pdf/(:num)', 'Crm\QuotesController::pdf/$1');
    $routes->get('quotes/view/(:num)', 'Crm\QuotesController::view/$1');
    $routes->post('quotes/store', 'Crm\QuotesController::store'); 
    $routes->post('quotes/approve/(:num)', 'Crm\QuotesController::approve/$1');
    $routes->get('quotes/edit/(:num)', 'Crm\EditQuotesController::edit/$1');
    $routes->put('quotes/update/(:num)', 'Crm\EditQuotesController::update/$1');
    $routes->delete('quotes/delete/(:num)', 'Crm\QuotesController::delete/$1');


    // COMPANIES
    $routes->get('companies', 'Crm\CompaniesController::index');
    $routes->get('companies/view/(:num)', 'Crm\CompaniesController::view/$1');

    //orders 
    $routes->get('orders', 'Crm\OrdersController::index');
    $routes->get('orders/view/(:num)', 'Crm\OrdersController::view/$1');

    //apartados
    $routes->get('apartados/view/(:num)', 'Crm\ApartadosController::view/$1');
    
    //pagos
    $routes->post('payments/store', 'Payments\PaymentsController::store');
});

//agenda
$routes->group('agenda', function ($routes) {
    $routes->get('/', 'AgendaController::index');

    $routes->post('save', 'AgendaController::save');       // crear
    $routes->post('update/(:num)', 'AgendaController::update/$1'); // editar
    $routes->post('delete/(:num)', 'AgendaController::delete/$1');
});

//envios
$routes->group('shipments', function ($routes) {
    // Dashboard de envíos
    $routes->get('/', 'Shipment\ShipmentController::index');
});

