<?php

namespace App\Controllers;

class DashboardController extends BaseController
{
    public function index()
    {
        if (!session()->is_logged) return redirect()->to('/login');
        // KPIs (luego vienen de la BD)
        $data = [
            'kpis' => [
                'activos'     => 128,
                'transito'    => 76,
                'entregados'  => 34,
                'incidencias' => 5,
            ],

            // Gráfica (últimos 7 días)
            'chartLabels' => ['Lun', 'Mar', 'Mié', 'Jue', 'Vie', 'Sáb', 'Dom'],
            'chartData'   => [12, 19, 14, 22, 18, 9, 15],

            // Tabla
            'envios' => [
                [
                    'folio'   => 'TEF1021',
                    'cliente' => 'Amazon',
                    'origen'  => 'CDMX',
                    'destino' => 'Guadalajara',
                    'estado'  => 'transito'
                ],
                [
                    'folio'   => 'TEF1018',
                    'cliente' => 'Mercado Libre',
                    'origen'  => 'Monterrey',
                    'destino' => 'CDMX',
                    'estado'  => 'entregado'
                ],
                [
                    'folio'   => 'TEF1009',
                    'cliente' => 'Liverpool',
                    'origen'  => 'Querétaro',
                    'destino' => 'Puebla',
                    'estado'  => 'incidencia'
                ]
            ]
        ];

        return view('dashboard', $data);
    }
}
