<?php

namespace App\Controllers\Payments;

use App\Controllers\BaseController;
use App\Models\Payments\QuotePaymentModel;
use App\Models\Payments\QuoteBalanceModel;
use App\Models\Quotes\QuotesModel;
use App\Models\Quotes\OrderModel;

class PaymentsController extends BaseController
{
    protected $paymentModel;
    protected $balanceModel;
    protected $quoteModel;
    protected $orderModel;

    public function __construct()
    {
        $this->paymentModel = new QuotePaymentModel();
        $this->balanceModel = new QuoteBalanceModel();
        $this->quoteModel   = new QuotesModel();
        $this->orderModel   = new OrderModel();
    }

    public function store()
    {
        $db = \Config\Database::connect();
        $db->transBegin();

        try {

            $quoteId = $this->request->getPost('FK_Quote');
            $amount  = (float)$this->request->getPost('amount');

            if (!$quoteId || $amount <= 0) {
                throw new \Exception('Monto inválido');
            }

            // =========================
            // Balance
            // =========================

            $balance = $this->balanceModel
                ->where('FK_Quote',$quoteId)
                ->first();

            if (!$balance) {
                throw new \Exception('No existe balance');
            }

            $total = (float)$balance['Total_amount'];
            $paid  = (float)$balance['Paid_amount'];

            $newPaid = $paid + $amount;
            if ($newPaid > $total) $newPaid = $total;

            $newBalance = $total - $newPaid;

            // =========================
            // Tipo pago
            // =========================

            $type = ($newPaid >= $total) ? 'Contado' : 'Parcial';

            // =========================
            // Insertar pago
            // =========================

            $this->paymentModel->insert([
                'FK_Quote'       => $quoteId,
                'Payment_method' => $this->request->getPost('payment_method'),
                'Payment_type'   => $type,
                'Amount'         => $amount,
                'Reference'      => $this->request->getPost('reference'),
                'Notes'          => $this->request->getPost('notes'),
                'Paid_at'        => date('Y-m-d H:i:s'),
                'Created_at'     => date('Y-m-d H:i:s'),
                'Created_by'     => session('nombre')
            ]);

            // =========================
            // Update balance
            // =========================

            $this->balanceModel->update($balance['PK_Balance'],[
                'Paid_amount'    => $newPaid,
                'Balance'        => $newBalance,
                'Payment_status' => $newBalance <= 0 ? 'Pagado' : 'Pendiente',
                'Updated_at'     => date('Y-m-d H:i:s')
            ]);

            // =========================
            // 🔥 SI LIQUIDA → CREAR ORDEN
            // =========================

            if ($newBalance <= 0) {

                $quote = $this->quoteModel->find($quoteId);
                if (!$quote) {
                    throw new \Exception('Quote no existe');
                }

                // ya existe orden?
                $existing = $this->orderModel
                    ->where('FK_Quote',$quoteId)
                    ->first();

                if (!$existing) {

                    $data = $quote;
                    unset($data['PK_Quote']);

                    $data['FK_Quote']   = $quoteId;
                    $data['Status']     = 'Orden de Envio';
                    $data['Created_at'] = date('Y-m-d H:i:s');

                    $this->orderModel->insert($data);
                    $orderId = $this->orderModel->getInsertID();

                    $year = date('Y');

                    $this->orderModel->update($orderId,[
                        'Order_number' =>
                            'ORD-' . $year . '-' . str_pad($orderId,6,'0',STR_PAD_LEFT)
                    ]);

                } else {
                    $orderId = $existing['PK_Order'];
                }

                // actualizar quote status
                $this->quoteModel->update($quoteId,[
                    'Status'     => 'Orden de Envio',
                    'Updated_at' => date('Y-m-d H:i:s')
                ]);

                $db->transCommit();

                return redirect()->to('crm/orders/view/' . $orderId)->with('swal',[
                    'icon'=>'success',
                    'title'=>'Liquidado',
                    'text'=>'Se pago el total'
                ]);

            }

            // =========================
            // si no liquida → normal
            // =========================

            $db->transCommit();

            return redirect()->back()->with('swal',[
                'icon'=>'success',
                'title'=>'Pago registrado',
                'text'=>'Se agregó correctamente'
            ]);

        } catch (\Throwable $e) {

            $db->transRollback();

            return redirect()->back()->with('swal',[
                'icon'=>'error',
                'title'=>'Error',
                'text'=>$e->getMessage()
            ]);
        }
    }
}
