<?php

if (!function_exists('fmt_money')) {
    function fmt_money($n): string {
        if ($n === null || $n === '') return '';
        return '$'.number_format((float)$n, 2, '.', ',');
    }
}

if (!function_exists('fmt_date_dmY')) {
    function fmt_date_dmY($val, $fallback = null): string {
        if (empty($val)) return $fallback ?: date('d/m/Y');
        $ts = is_numeric($val) ? (int)$val : strtotime((string)$val);
        if (!$ts) return $fallback ?: date('d/m/Y');
        return date('d/m/Y', $ts);
    }
}

if (!function_exists('up')) {
    function up(?string $s): string {
        $s = trim((string)$s);
        return $s === '' ? '' : mb_strtoupper($s, 'UTF-8');
    }
}

if (!function_exists('fill_or_line')) {
    function fill_or_line(?string $s, string $line = '____________________________'): string {
        $s = trim((string)$s);
        return $s === '' ? $line : up($s);
    }
}

if (!function_exists('fmt_phone_mx')) {
    function fmt_phone_mx($p): string {
        $p = preg_replace('/\D+/', '', (string)$p);
        if ($p === '') return '';
        // 10 dígitos: 3-3-4 | 12 dígitos: 2-4-4-2 (ajusta si quieres)
        if (strlen($p) === 10) return substr($p,0,3).' '.substr($p,3,3).' '.substr($p,6);
        return $p; // fallback
    }
}


if (!function_exists('normalizar_contrato')) {
    /**
     * Recibe $c (fila de v_contratos_activos_info) y devuelve un arreglo
     * con todos los campos normalizados y cálculos listos para la vista.
     */
    function normalizar_contrato(array $c): array
    {
        // Identificadores / cabecera
        $contratoNo = $c['numero_contrato']
            ?? ($c['folio'] ?? ('C-'.str_pad((int)($c['contrato_id'] ?? 0), 5, '0', STR_PAD_LEFT)));

        $folio      = $c['folio'] ?? null;
        $fechaFirma = fmt_date_dmY($c['fecha_recepcion'] ?? ($c['fecha_registro'] ?? null));
        $estado     = $c['estado_contrato'] ?? ($c['estado'] ?? null);
        $paquete    = $c['paquete_clave'] ?? ($c['paquete'] ?? null);
        $canal      = $c['canal_venta_contrato'] ?? ($c['canal'] ?? null);

        // Cliente
        $clienteNombre = $c['cliente_nombre_completo']
            ?? trim(($c['nombre_cliente'] ?? $c['nombre'] ?? '') . ' ' . ($c['apellido_paterno'] ?? '') . ' ' . ($c['apellido_materno'] ?? ''));

        // Importes base (si tu vista los trae)
        $importeFuturo   = $c['importe_servicios_futuro']      ?? null;
        $descuentoFuturo = $c['descuento_servicios_futuro']    ?? null;
        $netoFuturo      = $c['neto_servicios_futuro']         ?? null;
        $ivaFuturo       = $c['iva_servicios_futuro']          ?? null;
        $totalFuturo     = $c['total_servicios_futuro']        ?? null;

        $importeAdic     = $c['importe_servicios_adicionales'] ?? null;
        $descuentoAdic   = $c['descuento_servicios_adicionales'] ?? null;
        $netoAdic        = $c['neto_servicios_adicionales']    ?? null;
        $ivaAdic         = $c['iva_servicios_adicionales']     ?? null;
        $totalAdic       = $c['total_servicios_adicionales']   ?? null;

        // Pagos (opción 1: último registro unido como pago_*)
        $ultimoMetodoPago  = $c['pago_metodo_pago']           ?? null;
        $totalPagar        = $c['pago_total_pagar']           ?? null;
        $sinAnticipos      = (int)($c['pago_sin_anticipos']   ?? 0) === 1;
        $anticipo1         = (float)($c['pago_anticipo1']     ?? 0);
        $anticipo2         = (float)($c['pago_anticipo2']     ?? 0);
        $fechaAnticipo1    = $c['pago_fecha_anticipo1']       ?? null;
        $fechaAnticipo2    = $c['pago_fecha_anticipo2']       ?? null;

        $fechaInicioAbonos = $c['pago_fecha_inicio_abonos']   ?? null;
        $periodicidadRaw   = $c['pago_periodicidad']          ?? null;
        $totalPagosCalc    = $c['pago_calc_total_pagos']      ?? null;
        $montoPagoCalc     = $c['pago_calc_monto_pago']       ?? null;

        $map = [
            'mensual' => 'mensual',
            'semanal' => 'semanal',
            'quincenal' => 'quincenal',
            'bimestral' => 'bimestral',
            'trimestral' => 'trimestral',
        ];
        $periodicidad = $periodicidadRaw ? ($map[strtolower((string)$periodicidadRaw)] ?? $periodicidadRaw) : null;

        // Cálculos
        $enganche = $sinAnticipos ? 0.0 : ($anticipo1 + $anticipo2);
        $saldo    = ($totalPagar !== null) ? max(0, (float)$totalPagar - (float)$enganche) : null;

        $tsNombre = $c['nombre_titular_sustituto'] ?? $c['titular_sustituto_nombre'] ?? null;
        $tsCel    = $c['celular_titular_sustituto'] ?? $c['titular_sustituto_cel'] ?? null;

        $b1Nom = $c['nombre_beneficiario_1'] ?? $c['beneficiario_1_nombre'] ?? null;
        $b1Cel = $c['celular_beneficiario_1'] ?? $c['beneficiario_1_cel'] ?? null;

        $b2Nom = $c['nombre_beneficiario_2'] ?? $c['beneficiario_2_nombre'] ?? null;
        $b2Cel = $c['celular_beneficiario_2'] ?? $c['beneficiario_2_cel'] ?? null;

        return [
            // básicos
            'contratoNo'   => $contratoNo,
            'folio'        => $folio,
            'fechaFirma'   => $fechaFirma,
            'estado'       => $estado,
            'paquete'      => $paquete,
            'canal'        => $canal,
            'clienteNombre'=> $clienteNombre,

            // importes
            'importeFuturo'   => $importeFuturo,
            'descuentoFuturo' => $descuentoFuturo,
            'netoFuturo'      => $netoFuturo,
            'ivaFuturo'       => $ivaFuturo,
            'totalFuturo'     => $totalFuturo,

            'importeAdic'     => $importeAdic,
            'descuentoAdic'   => $descuentoAdic,
            'netoAdic'        => $netoAdic,
            'ivaAdic'         => $ivaAdic,
            'totalAdic'       => $totalAdic,

            // pagos
            'ultimoMetodoPago'  => $ultimoMetodoPago,
            'totalPagar'        => $totalPagar,
            'sinAnticipos'      => $sinAnticipos,
            'anticipo1'         => $anticipo1,
            'anticipo2'         => $anticipo2,
            'fechaAnticipo1'    => $fechaAnticipo1,
            'fechaAnticipo2'    => $fechaAnticipo2,
            'fechaInicioAbonos' => $fechaInicioAbonos,
            'periodicidad'      => $periodicidad,
            'numAbonos'         => $totalPagosCalc,
            'montoAbono'        => $montoPagoCalc,

            // designaciones
            'tsNombre' => $tsNombre,
            'tsCel'    => $tsCel,
            'b1Nom'    => $b1Nom,
            'b1Cel'    => $b1Cel,
            'b2Nom'    => $b2Nom,
            'b2Cel'    => $b2Cel,

            // derivados
            'enganche'          => $enganche,
            'saldo'             => $saldo,
        ];
    }
}
