<?php

if (!function_exists('formatear_fecha_larga')) {
    function formatear_fecha_larga($fecha)
    {
        if (!$fecha) return '';

        $timestamp = is_numeric($fecha) ? $fecha : strtotime($fecha);

        // Definir días y meses en español
        $dias = ['domingo', 'lunes', 'martes', 'miércoles', 'jueves', 'viernes', 'sábado'];
        $meses = [
            'enero', 'febrero', 'marzo', 'abril', 'mayo', 'junio',
            'julio', 'agosto', 'septiembre', 'octubre', 'noviembre', 'diciembre'
        ];

        $diaSemana = $dias[date('w', $timestamp)];
        $dia = date('d', $timestamp);
        $mes = $meses[date('n', $timestamp) - 1];
        $anio = date('Y', $timestamp);
        $hora = date('h:i a', $timestamp); // hora con am/pm

        return "{$diaSemana} {$dia} de {$mes} del {$anio} a las {$hora}";
    }
}

function formatear_fecha_larga_simple($fecha)
{
    if (!$fecha) return '';

    $timestamp = strtotime($fecha);

    $dias = ['domingo', 'lunes', 'martes', 'miércoles', 'jueves', 'viernes', 'sábado'];
    $meses = ['enero', 'febrero', 'marzo', 'abril', 'mayo', 'junio',
            'julio', 'agosto', 'septiembre', 'octubre', 'noviembre', 'diciembre'];

    $diaSemana = $dias[date('w', $timestamp)];
    $dia = date('d', $timestamp);
    $mes = $meses[date('n', $timestamp) - 1];
    $anio = date('Y', $timestamp);

    return "{$diaSemana} {$dia} de {$mes} del {$anio}";
}
