<?php

if (!function_exists('generar_slug_pago')) {
    function generar_slug_pago(string $contrato, int $parcialidad, string $fechaPago): string
    {
        $base = $contrato . '-p' . $parcialidad . '-' . date('Y-m-d', strtotime($fechaPago));

        return strtolower(
            preg_replace(
                '/[^a-z0-9\-]/',
                '',
                str_replace(' ', '-', $base)
            )
        );
    }
}
