<?php

namespace App\Models\Quotes;

use CodeIgniter\Model;

class QuotesModel extends Model
{
    protected $table      = 't_quotes';
    protected $primaryKey = 'PK_Quote';

    protected $returnType = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = [
        'FK_Contact',
        'Quote_number',

        'Origin_name','Origin_address','Origin_city','Origin_state','Origin_zip','Origin_country',
        'Destination_name','Destination_address','Destination_city','Destination_state','Destination_zip','Destination_country', 'Destination_phone',

        'Pieces','Weight_kg','Length_cm','Width_cm','Height_cm','Volumetric_weight',
        'Service_type',

        'Insurance_amount','Declared_value',

        'Operation_cost',
        'Packaging_pct','Packaging_cost',
        'Base_cost',
        'Margin_pct','Margin_amount',
        'Subtotal',

        'Administrative_cost','Insurance_cost','Taxes',
        'Total_amount',

        'Currency',
        'Status',
        'Quoted_at',
        'Expires_at',
        'Created_at',
        'Updated_at',
        'Comments'
    ];


    protected $useTimestamps = false;

    /* ============================
       Helpers de negocio
    ============================ */

    /**
     * Genera número de cotización
     * Ej: COT-2026-000123
     */
    public function generateQuoteNumber(): string
    {
        $year = date('Y');

        $count = $this->where('YEAR(Created_at)', $year)
            ->countAllResults() + 1;

        return 'COT-' . $year . '-' . str_pad($count, 6, '0', STR_PAD_LEFT);
    }
}
