<?php

namespace App\Validation;

use App\Models\Clientes\DatosModel;

class CustomRules
{
    /**
     * Uso:
     *  uniqueNombreCompleto[apellido_paterno,apellido_materno,nombre]
     * Ignora el propio registro si viene el PK en $data (para updates).
     */
    public function uniqueNombreCompleto(string $str, string $fields, array $data, ?string &$error = null): bool
    {
        $campos = array_map('trim', explode(',', $fields));
        [$apField, $amField, $nomField] = $campos + [null, null, null];

        $ap  = trim($data[$apField]  ?? '');
        $am  = trim($data[$amField]  ?? '');
        $nom = trim($data[$nomField] ?? '');

        if ($ap === '' || $am === '' || $nom === '') {
            return true;
        }

        $model = new DatosModel();

        $builder = $model->where([
            'apellido_paterno' => $ap,
            'apellido_materno' => $am,
            'nombre'           => $nom,
        ]);

        // Ignorar el propio registro en update si viene el PK
        $pkName = $model->primaryKey ?? 'id';
        $pk     = $data[$pkName] ?? null;
        if (!empty($pk)) {
            $builder->where($pkName . ' !=', $pk);
        }

        $dup = $builder->first();

        if ($dup) {
            $error = 'Ya existe una persona con el mismo nombre y apellidos.';
            return false;
        }

        return true;
    }
}
