<?= $this->extend('layouts/layout') ?>

<?= $this->section('titulo') ?>Registro Cliente | TEF Paquetería<?= $this->endSection() ?>

<?= $this->section('estilos') ?>
    <link rel="stylesheet" href="<?= base_url('css/tef/registro.css?v='.time()) ?>">
<?= $this->endSection() ?>

<?= $this->section('contenido') ?>

<div class="container-fluid dashboard-wrapper py-4">
    <div class="card shadow-sm wizard-container">
        <div class="card-header bg-dark text-white">
            <h5 class="mb-0">Registrar nuevo cliente</h5>
        </div>

        <!-- Barra de progreso -->
        <div class="card-body py-3">
            <div class="progress-wizard mb-4">
                <div class="progress-step active-step">
                    <i class="fas fa-user"></i>
                    <div class="progress-step-label">Información</div>
                </div>
                <div class="progress-step">
                    <i class="fas fa-map-marker-alt"></i>
                    <div class="progress-step-label">Dirección</div>
                </div>
                <div class="progress-step">
                    <i class="fas fa-check"></i>
                    <div class="progress-step-label">Confirmación</div>
                </div>
                <div class="progress-step">
                    <i class="fas fa-info-circle"></i>
                    <div class="progress-step-label">Adicional</div>
                </div>
            </div>
        </div>

        <!-- Wizard Forms -->
        <div class="card-body position-relative" style="padding-top: 1rem;">

            <!-- Paso 1 -->
            <div class="step-form active">
                <div class="row g-3">
                    <div class="col-12"><label for="nombre" class="form-label">Nombre</label><input type="text" class="form-control" id="nombre" placeholder="Nombre del cliente"></div>
                    <div class="col-md-6"><label for="email" class="form-label">Correo electrónico</label><input type="email" class="form-control" id="email" placeholder="ejemplo@correo.com"></div>
                    <div class="col-md-6"><label for="telefono" class="form-label">Teléfono</label><input type="text" class="form-control" id="telefono" placeholder="55 1234 5678"></div>
                    <div class="col-12"><label for="empresa" class="form-label">Empresa</label><input type="text" class="form-control" id="empresa" placeholder="Nombre de la empresa"></div>
                    <div class="col-12 text-end"><button type="button" class="btn btn-primary next-step">Siguiente</button></div>
                </div>
            </div>

            <!-- Paso 2 -->
            <div class="step-form inactive-right">
                <div class="row g-3">
                    <div class="col-12"><label for="calle" class="form-label">Calle</label><input type="text" class="form-control" id="calle" placeholder="Calle"></div>
                    <div class="col-md-6"><label for="ciudad" class="form-label">Ciudad</label><input type="text" class="form-control" id="ciudad" placeholder="Ciudad"></div>
                    <div class="col-md-6"><label for="cp" class="form-label">Código Postal</label><input type="text" class="form-control" id="cp" placeholder="CP"></div>
                    <div class="col-12 d-flex justify-content-between">
                        <button type="button" class="btn btn-secondary prev-step">Anterior</button>
                        <button type="button" class="btn btn-primary next-step">Siguiente</button>
                    </div>
                </div>
            </div>

            <!-- Paso 3: Confirmación -->
            <div class="step-form inactive-right">
                <div class="row g-3">
                    <div class="col-12">
                        <h6>Revise la información antes de guardar</h6>
                        <ul class="list-group">
                            <li class="list-group-item"><b>Nombre:</b> <span id="confirmNombre"></span></li>
                            <li class="list-group-item"><b>Email:</b> <span id="confirmEmail"></span></li>
                            <li class="list-group-item"><b>Teléfono:</b> <span id="confirmTelefono"></span></li>
                            <li class="list-group-item"><b>Empresa:</b> <span id="confirmEmpresa"></span></li>
                            <li class="list-group-item"><b>Calle:</b> <span id="confirmCalle"></span></li>
                            <li class="list-group-item"><b>Ciudad:</b> <span id="confirmCiudad"></span></li>
                            <li class="list-group-item"><b>Código Postal:</b> <span id="confirmCP"></span></li>
                        </ul>
                    </div>
                    <div class="col-12 d-flex justify-content-between">
                        <button type="button" class="btn btn-secondary prev-step">Anterior</button>
                        <button type="button" class="btn btn-primary next-step">Siguiente</button>
                    </div>
                </div>
            </div>

            <!-- Paso 4: Información adicional -->
            <div class="step-form inactive-right">
                <div class="row g-3">
                    <div class="col-md-6"><label for="asignado" class="form-label">Asignar a</label>
                        <select class="form-select" id="asignado">
                            <option value="">Seleccionar usuario</option>
                            <option value="1">Juan Pérez</option>
                            <option value="2">María López</option>
                            <option value="3">Equipo Ventas</option>
                        </select>
                    </div>
                    <div class="col-md-6"><label for="tipoCliente" class="form-label">Tipo de cliente</label>
                        <select class="form-select" id="tipoCliente">
                            <option value="">Seleccionar tipo</option>
                            <option value="prospecto">Prospecto</option>
                            <option value="cliente">Cliente</option>
                            <option value="socio">Socio</option>
                        </select>
                    </div>
                    <div class="col-12"><label for="notas" class="form-label">Notas adicionales</label><textarea class="form-control" id="notas" rows="3" placeholder="Escribe alguna nota o comentario"></textarea></div>
                    <div class="col-12">
                        <label class="form-label">Categorías</label>
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" value="VIP" id="catVIP">
                            <label class="form-check-label" for="catVIP">VIP</label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" value="Regular" id="catRegular">
                            <label class="form-check-label" for="catRegular">Regular</label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" value="Potencial" id="catPotencial">
                            <label class="form-check-label" for="catPotencial">Potencial</label>
                        </div>
                    </div>
                    <div class="col-12 d-flex justify-content-between">
                        <button type="button" class="btn btn-secondary prev-step">Anterior</button>
                        <button type="button" id="guardarClienteBtn" class="btn btn-success">Guardar cliente</button>
                    </div>
                </div>
            </div>

        </div>
    </div>
</div>



<?= $this->section('scripts') ?>
<script>
const dashboardUrl = "<?= site_url('customer/customer_dashboard') ?>";
document.addEventListener('DOMContentLoaded', () => {
    const steps = document.querySelectorAll('.step-form');
    const nextBtns = document.querySelectorAll('.next-step');
    const prevBtns = document.querySelectorAll('.prev-step');
    const progressSteps = document.querySelectorAll('.progress-step');
    let currentStep = 0;

    function updateStepDisplay() {
        steps.forEach((step, i) => {
            step.classList.remove('active', 'inactive-left', 'inactive-right');
            if (i < currentStep) step.classList.add('inactive-left');
            else if (i > currentStep) step.classList.add('inactive-right');
            else step.classList.add('active');
        });

        progressSteps.forEach((p, i) => {
            p.classList.toggle('completed', i < currentStep);
            p.classList.toggle('active-step', i === currentStep);
        });

        // Actualizar confirmación en Paso 3
        if (currentStep >= 2) {
            document.getElementById('confirmNombre').textContent = document.getElementById('nombre').value;
            document.getElementById('confirmEmail').textContent = document.getElementById('email').value;
            document.getElementById('confirmTelefono').textContent = document.getElementById('telefono').value;
            document.getElementById('confirmEmpresa').textContent = document.getElementById('empresa').value;
            document.getElementById('confirmCalle').textContent = document.getElementById('calle').value;
            document.getElementById('confirmCiudad').textContent = document.getElementById('ciudad').value;
            document.getElementById('confirmCP').textContent = document.getElementById('cp').value;
        }
    }

    nextBtns.forEach(btn => {
        btn.addEventListener('click', () => {
            currentStep = Math.min(currentStep + 1, steps.length - 1);
            updateStepDisplay();
        });
    });

    prevBtns.forEach(btn => {
        btn.addEventListener('click', () => {
            currentStep = Math.max(currentStep - 1, 0);
            updateStepDisplay();
        });
    });

    // Botón Guardar cliente con SweetAlert2
    const guardarBtn = document.getElementById('guardarClienteBtn');
    guardarBtn.addEventListener('click', () => {

        // Aquí puedes capturar los datos si necesitas enviarlos por AJAX
        const clienteData = {
            nombre: document.getElementById('nombre').value,
            email: document.getElementById('email').value,
            telefono: document.getElementById('telefono').value,
            empresa: document.getElementById('empresa').value,
            calle: document.getElementById('calle').value,
            ciudad: document.getElementById('ciudad').value,
            cp: document.getElementById('cp').value,
            asignado: document.getElementById('asignado').value,
            tipoCliente: document.getElementById('tipoCliente').value,
            notas: document.getElementById('notas').value
        };

        // Mostrar alerta de éxito
        Swal.fire({
            icon: 'success',
            title: 'Cliente registrado',
            text: 'El cliente se ha guardado correctamente',
            confirmButtonText: 'Ir al Dashboard'
        }).then((result) => {
            if(result.isConfirmed) {
                // Redirigir al dashboard
                window.location.href = dashboardUrl;
            }
        });
    });

    updateStepDisplay();
});
</script>
<?= $this->endSection() ?>

<?= $this->endSection() ?>
