<?= $this->extend('layouts/layout') ?>

<?= $this->section('titulo') ?>Cliente | TEF Paquetería<?= $this->endSection() ?>

<?= $this->section('contenido') ?>

<div class="container-fluid dashboard-wrapper py-4">

    <!-- Nombre y acciones rápidas -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h4 class="text-light mb-0">Cliente: <b id="clienteNombre">Juan Pérez</b></h4>
        <div>
            <a href="<?= site_url('shipment/new_shipment') ?>" class="btn btn-primary me-2">Nuevo envío</a>
            <button class="btn btn-secondary me-2">Editar cliente</button>
            <button class="btn btn-info">Agregar contacto</button>
        </div>
    </div>

    <!-- KPIs del cliente -->
    <div class="row g-4 mb-4">
        <div class="col-xl-3 col-md-6">
            <div class="tef-card kpi-card">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <div class="kpi-value" id="enviosActivos">0</div>
                        <div class="kpi-label">Envíos activos</div>
                    </div>
                    <div class="kpi-icon"><i class="fas fa-box"></i></div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-md-6">
            <div class="tef-card kpi-card">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <div class="kpi-value" id="enviosTransito">0</div>
                        <div class="kpi-label">En tránsito</div>
                    </div>
                    <div class="kpi-icon"><i class="fas fa-truck"></i></div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-md-6">
            <div class="tef-card kpi-card">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <div class="kpi-value" id="enviosEntregados">0</div>
                        <div class="kpi-label">Entregados</div>
                    </div>
                    <div class="kpi-icon"><i class="fas fa-check-circle"></i></div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-md-6">
            <div class="tef-card kpi-card">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <div class="kpi-value" id="incidenciasCliente">0</div>
                        <div class="kpi-label">Incidencias</div>
                    </div>
                    <div class="kpi-icon"><i class="fas fa-exclamation-triangle"></i></div>
                </div>
            </div>
        </div>
    </div>

    <!-- Información general del cliente -->
    <div class="tef-panel mb-4">
        <div class="tef-panel-title">Información general</div>
        <div class="row g-3">
            <div class="col-md-6">
                <b>Email:</b> <span id="clienteEmail">juan.perez@correo.com</span>
            </div>
            <div class="col-md-6">
                <b>Teléfono:</b> <span id="clienteTelefono">55 1234 5678</span>
            </div>
            <div class="col-md-6">
                <b>Empresa:</b> <span id="clienteEmpresa">Empresa XYZ</span>
            </div>
            <div class="col-md-6">
                <b>Dirección:</b> <span id="clienteDireccion">Calle 123, Ciudad, CP 01234</span>
            </div>
        </div>
    </div>

    <!-- Gráficas pequeñas -->
    <div class="row g-4 mb-4">
        <div class="col-md-6">
            <div class="tef-panel" style="height:400px;">
                <div class="tef-panel-title">Envíos por estado</div>
                <canvas id="chartEstado" ></canvas>
            </div>
        </div>
        <div class="col-md-6">
            <div class="tef-panel" style="height:400px;">
                <div class="tef-panel-title">Envíos últimos 7 días</div>
                <canvas id="chartSemanal" ></canvas>
            </div>
        </div>
    </div>


    <!-- Tabla de envíos recientes del cliente -->
    <div class="tef-panel">
        <div class="tef-panel-title">Envíos recientes</div>
        <div class="table-responsive tef-table">
            <table class="table table-dark table-hover mb-0">
                <thead>
                    <tr>
                        <th>Folio</th>
                        <th>Origen</th>
                        <th>Destino</th>
                        <th>Estado</th>
                        <th>Fecha</th>
                    </tr>
                </thead>
                <tbody id="tablaEnvios">
                    <!-- Aquí se llenará dinámicamente con JS -->
                    <tr>
                        <td>#TEF1021</td>
                        <td>CDMX</td>
                        <td>Guadalajara</td>
                        <td><span class="tef-status info">En tránsito</span></td>
                        <td>23/12/2025</td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>

</div>

<?= $this->section('scripts') ?>
<script>
document.addEventListener('DOMContentLoaded', () => {
    
    // Simulación de datos del cliente
    const cliente = {
        nombre: "Juan Pérez",
        email: "juan.perez@correo.com",
        telefono: "55 1234 5678",
        empresa: "Empresa XYZ",
        direccion: "Calle 123, Ciudad, CP 01234",
        envios: [
            {folio: "#TEF1021", origen: "CDMX", destino: "Guadalajara", estado: "En tránsito", fecha: "23/12/2025"},
            {folio: "#TEF1018", origen: "Monterrey", destino: "CDMX", estado: "Entregado", fecha: "22/12/2025"},
            {folio: "#TEF1009", origen: "Querétaro", destino: "Puebla", estado: "Incidencia", fecha: "21/12/2025"},
        ]
    };

    // Llenar información general
    document.getElementById('clienteNombre').textContent = cliente.nombre;
    document.getElementById('clienteEmail').textContent = cliente.email;
    document.getElementById('clienteTelefono').textContent = cliente.telefono;
    document.getElementById('clienteEmpresa').textContent = cliente.empresa;
    document.getElementById('clienteDireccion').textContent = cliente.direccion;

    // Llenar KPIs
    const estados = cliente.envios.reduce((acc, envio) => {
        if(envio.estado === "En tránsito") acc.transito++;
        else if(envio.estado === "Entregado") acc.entregado++;
        else if(envio.estado === "Incidencia") acc.incidencia++;
        return acc;
    }, {transito:0, entregado:0, incidencia:0});

    document.getElementById('enviosActivos').textContent = cliente.envios.length;
    document.getElementById('enviosTransito').textContent = estados.transito;
    document.getElementById('enviosEntregados').textContent = estados.entregado;
    document.getElementById('incidenciasCliente').textContent = estados.incidencia;

    // Llenar tabla de envíos
    const tbody = document.getElementById('tablaEnvios');
    tbody.innerHTML = "";
    cliente.envios.forEach(envio => {
        const tr = document.createElement('tr');
        tr.innerHTML = `
            <td>${envio.folio}</td>
            <td>${envio.origen}</td>
            <td>${envio.destino}</td>
            <td><span class="tef-status ${envio.estado === 'Entregado' ? 'success' : envio.estado === 'En tránsito' ? 'info' : 'danger'}">${envio.estado}</span></td>
            <td>${envio.fecha}</td>
        `;
        tbody.appendChild(tr);
    });
    // Datos para gráficas
const ctxEstado = document.getElementById('chartEstado').getContext('2d');
const chartEstado = new Chart(ctxEstado, {
    type: 'doughnut',
    data: {
        labels: ['En tránsito', 'Entregado', 'Incidencias'],
        datasets: [{
            data: [estados.transito, estados.entregado, estados.incidencia],
            backgroundColor: ['#4da6ff','#4caf50','#f44336'],
            borderWidth: 1
        }]
    },
    options: {
        responsive: true,
        maintainAspectRatio: false,
        plugins: {
            legend: { position: 'bottom', labels: { color: '#eee' } }
        },
        scales: {
            x: { ticks: { color: '#eee' }, grid: { color: '#444' } },
            y: { ticks: { color: '#eee' }, grid: { color: '#444' } }
        }
    }
});

    // Envíos últimos 7 días (ejemplo)
    const ctxSemanal = document.getElementById('chartSemanal').getContext('2d');
    const chartSemanal = new Chart(ctxSemanal, {
        type: 'bar',
        data: {
            labels: ['Lun','Mar','Mié','Jue','Vie','Sáb','Dom'],
            datasets: [{
                label: 'Envíos',
                data: [2,3,1,4,2,1,3], // ejemplo
                backgroundColor: '#caa24d'
            }]
        },
        options: {
            responsive: true,
            plugins: { legend: { display: false } },
            scales: {
                x: { ticks: { color: '#eee' }, grid: { color: '#444' } },
                y: { ticks: { color: '#eee' }, grid: { color: '#444' } }
            }
        }
    });

});
</script>
<?= $this->endSection() ?>

<?= $this->endSection() ?>
