<?= $this->extend('layouts/layout') ?>

<?= $this->section('titulo') ?>Apartado<?= $this->endSection() ?>

<?= $this->section('contenido') ?>

<?php $isApartado = ($order['Status'] ?? '') === 'Apartado'; ?>

<style>
.module-locked {
    opacity: .45;
    pointer-events: none;
    filter: grayscale(60%);
    position: relative;
}

.lock-badge {
    font-size: 13px;
    margin-left: 8px;
    color: #ffcc66;
}
</style>

<div class="tef-card" style="margin: 20px auto;">

<?php if ($isApartado): ?>
<div class="tef-alert">
    ⚠️ Orden en estado APARTADO — solo módulos de Detalles, Servicios y Pagos habilitados
</div>
<?php endif; ?>

<!-- Header -->
<div style="display:flex; justify-content: space-between; align-items:center; margin-bottom: 20px;">
    <div class="tef-panel-title" style="font-size: 22px;">
        Apartado #<?= $order['Apartado_number'] ?? '—' ?>
    </div>

    <div class="tef-dropdown">
        <button class="tef-btn tef-btn-primary">
            Descargar PDF ▾
        </button>

        <div class="tef-dropdown-menu">
            <a href="<?= site_url('crm/quotes/pdf/'.$order['FK_Quote'].'?lang=es') ?>" target="_blank">
                Español
            </a>
            <a href="<?= site_url('crm/quotes/pdf/'.$order['FK_Quote'].'?lang=en') ?>" target="_blank">
                English
            </a>
        </div>
    </div>
</div>

<!-- Timeline (BLOQUEADO) -->
<div class="tef-panel <?= $isApartado ? 'module-locked' : '' ?>" style="margin-bottom:20px;">
    <div class="tef-panel-title">
        Progreso del Envío
        <?php if ($isApartado): ?><span class="lock-badge">🔒</span><?php endif; ?>
    </div>

    <div style="display:flex; justify-content: space-between; padding: 10px 0;">
    <?php 
    $timeline = [
        ['title'=>'Orden Confirmada','date'=>'—','status'=>'success'],
        ['title'=>'Recolectado','date'=>'—','status'=>'muted'],
        ['title'=>'En tránsito','date'=>'—','status'=>'muted'],
        ['title'=>'Entrega programada','date'=>'—','status'=>'muted'],
        ['title'=>'Entregado','date'=>'—','status'=>'muted'],
    ];
    foreach($timeline as $step): ?>
        <div style="flex:1; text-align:center;">
            <div style="width:18px;height:18px;border-radius:50%;background:#555;margin:0 auto;"></div>
            <div style="font-size:12px;margin-top:6px;"><?= $step['title'] ?></div>
        </div>
    <?php endforeach; ?>
    </div>
</div>

<!-- Detalles (HABILITADO) -->
<div class="tef-panel" style="margin-bottom:20px;">
    <div class="tef-panel-title">Detalles de la Orden</div>

    <div style="display:flex; gap:20px; flex-wrap:wrap;">
        <div style="flex:1;">
            <ul class="activity-list">
                <li><b>Remitente:</b> <?= $order['Origin_name'] ?? 'Juan Pérez' ?></li>
                <li><b>Teléfono:</b> <?= $order['Origin_phone'] ?? '+52 55 1234 5678' ?></li>
                <li><b>Dirección:</b> <?= $order['Origin_address'] ?? 'Calle 45 #123, Ciudad, CP 45678' ?></li>
            </ul>
        </div>

        <div style="flex:1;">
            <ul class="activity-list">
                <li><b>Destinatario:</b> <?= $order['Destination_name'] ?></li>
                <li><b>Teléfono:</b> <?= $order['Destination_phone'] ?></li>
                <li><b>Dirección:</b> <?= $order['Destination_address'] ?></li>
            </ul>
        </div>

        <div style="flex:1;">
            <ul class="activity-list">
                <li><b>Total:</b> <?= $order['Currency'] ?><?= $order['Total_amount'] ?></li>
            </ul>
        </div>
    </div>
</div>

<!-- Estado (BLOQUEADO) -->
<div class="<?= $isApartado ? 'module-locked' : '' ?>" style="display:flex; gap:20px; margin-bottom:20px;">

    <div class="tef-panel" style="flex:1;">
        <div class="tef-panel-title">
            Estado Actual
            <?php if ($isApartado): ?><span class="lock-badge">🔒</span><?php endif; ?>
        </div>
        <ul class="activity-list">
            <li><b>Status:</b> <?= $order['Status'] ?></li>
        </ul>
    </div>

    <div class="tef-panel" style="flex:1;">
        <div class="tef-panel-title">
            Actualizar Estado
            <?php if ($isApartado): ?><span class="lock-badge">🔒</span><?php endif; ?>
        </div>

        <select class="tef-select" disabled>
            <option>En tránsito</option>
        </select>

        <button class="tef-btn tef-btn-primary" disabled style="margin-top:10px;">
            Actualizar
        </button>
    </div>

</div>

<!-- Servicios (HABILITADO) -->
<div class="tef-panel" style="margin-bottom:20px;">
    <div class="tef-panel-title">Servicios</div>

    <table class="c-table">
        <thead>
        <tr>
            <th>Servicio</th>
            <th>Cantidad</th>
            <th>Total</th>
        </tr>
        </thead>
        <tbody>
        <?php foreach($services as $service): ?>
        <tr>
            <td><?= $service['Service_name'] ?></td>
            <td><?= $service['Quantity'] ?></td>
            <td><?= $order['Currency'] ?><?= $service['Total'] ?></td>
        </tr>
        <?php endforeach; ?>
        </tbody>
    </table>
</div>

    <!-- Pagos (HABILITADO) -->
    <div style="display:flex; gap:20px;">

        <div class="tef-panel" style="flex:1;">
        <div class="tef-panel-title">Registrar Pago</div>

        <form method="post"
            action="<?= site_url('crm/payments/store') ?>">

            <?= csrf_field() ?>

            <input type="hidden"
                name="FK_Quote"
                value="<?= esc($order['FK_Quote']) ?>">

            <div class="tef-input-group">
                <label>Monto</label>
                <input type="number"
                    name="amount"
                    step="0.01"
                    required
                    class="tef-input"
                    placeholder="0.00">
            </div>

            <div class="tef-input-group">
                <label>Método de pago</label>
                <select name="payment_method"
                        required
                        class="tef-select">
                    <option value="">Seleccionar…</option>
                    <option>Efectivo</option>
                    <option>Tarjeta</option>
                    <option>Transferencia</option>
                    <option>Depósito</option>
                    <option>Cheque</option>
                </select>
            </div>

            <div class="tef-input-group">
                <label>Referencia</label>
                <input type="text"
                    name="reference"
                    class="tef-input"
                    placeholder="Folio / operación">
            </div>

            <div class="tef-input-group">
                <label>Notas</label>
                <textarea name="notes"
                        class="tef-textarea"
                        rows="2"></textarea>
            </div>

            <button class="tef-btn tef-btn-success"
                    style="margin-top:12px;">
                Registrar Pago
            </button>

        </form>
    </div>


    <div class="tef-panel" style="flex:1;">
        <div class="tef-panel-title">Historial de Pagos</div>

        <ul class="activity-list">

        <?php if (!empty($payments)): ?>

            <?php foreach ($payments as $p): ?>
                <li>
                    <b><?= esc($order['Currency']) ?>
                    <?= number_format((float)$p['Amount'], 2) ?></b>

                    — <?= esc($p['Payment_method']) ?>

                    — <?= !empty($p['Payment_type'])
                            ? esc($p['Payment_type'])
                            : '—' ?>

                    — <?= !empty($p['Paid_at'])
                            ? date('d M Y', strtotime($p['Paid_at']))
                            : '—' ?>
                </li>
            <?php endforeach; ?>

        <?php else: ?>

            <li style="opacity:.6;">No hay pagos registrados</li>

        <?php endif; ?>

        </ul>

        <hr style="margin:12px 0; opacity:.2;">

        <div class="activity-list">
            <li><b>Total:</b>
                <?= esc($order['Currency']) ?>
                <?= number_format((float)$balance['Total_amount'], 2) ?>
            </li>

            <li><b>Pagado:</b>
                <?= esc($order['Currency']) ?>
                <?= number_format((float)$balance['Paid_amount'], 2) ?>
            </li>

            <li><b>Pendiente:</b>
                <?= esc($order['Currency']) ?>
                <?= number_format((float)$balance['Balance'], 2) ?>
            </li>

            <li>
                <b>Estado:</b>
                <span class="tef-status <?= $balance['Balance'] <= 0 ? 'success' : 'danger' ?>">
                    <?= esc($balance['Payment_status']) ?>
                </span>
            </li>
        </div>

    </div>

</div>

<?= $this->endSection() ?>
<?= $this->section('scripts') ?>
<?php if (session()->getFlashdata('swal')): ?>
<script>
Swal.fire({
    icon: "<?= session('swal.icon') ?>",
    title: "<?= session('swal.title') ?>",
    text: "<?= session('swal.text') ?>",
    confirmButtonColor: "#1f7a4f"
});
</script>
<?php endif; ?>
<?= $this->endSection() ?>