<?= $this->extend('layouts/layout') ?>

<?= $this->section('titulo') ?>Empresas<?= $this->endSection() ?>

<?= $this->section('contenido') ?>

<div class="tef-panel">

    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h2>Empresas</h2>
            <p class="text-muted">Listado de empresas registradas</p>
        </div>
    </div>

    <div class="tef-table">
        <table class="c-table" id="companiesTable">
            <thead>
                <tr>
                    <th>Empresa</th>
                    <th>Sector</th>
                    <th>Ciudad</th>
                    <th>País</th>
                    <th class="text-center">Acciones</th>
                </tr>
            </thead>
            <tbody>

            <?php if (empty($companies)): ?>
                <tr>
                    <td colspan="5" class="text-muted text-center p-4">
                        No hay empresas registradas
                    </td>
                </tr>
            <?php else: ?>
                <?php foreach ($companies as $company): ?>
                    <tr>
                        <td><strong><?= esc($company['Company_name']) ?></strong></td>
                        <td><?= esc($company['Sector'] ?? '-') ?></td>
                        <td><?= esc($company['City'] ?? '-') ?></td>
                        <td><?= esc($company['Country'] ?? '-') ?></td>
                        <td class="text-center">
                            <a href="<?= site_url('crm/companies/view/'.$company['PK_Company']) ?>"
                               class="btn btn-sm btn-outline-primary">
                                Ver
                            </a>
                        </td>
                    </tr>
                <?php endforeach ?>
            <?php endif ?>

            </tbody>
        </table>
    </div>

</div>

<?= $this->endSection() ?>

<?= $this->section('scripts') ?>
<script>
$(document).ready(function () {
    $('#companiesTable').DataTable({
        pageLength: 25,
        lengthMenu: [10, 25, 50, 100],
        ordering: true,
        searching: true,
        info: true,
        language: {
            search: "Buscar:",
            lengthMenu: "Mostrar _MENU_ contactos",
            info: "Mostrando _START_ a _END_ de _TOTAL_ contactos",
            paginate: {
                previous: "Anterior",
                next: "Siguiente"
            },
            zeroRecords: "No se encontraron contactos"
        }
    });
});
</script>

<?= $this->endSection() ?>