<?= $this->extend('layouts/layout') ?>

<?= $this->section('titulo') ?>Empresa<?= $this->endSection() ?>

<?= $this->section('contenido') ?>

<div class="tef-panel">

    <h2><?= esc($company['Company_name']) ?></h2>
    <p class="text-muted">
        <?= esc($company['Sector'] ?? '—') ?>
    </p>

    <div class="tef-card mb-4">
        <strong>Dirección</strong><br>
        <?= esc($company['Address'] ?? '') ?><br>
        <?= esc($company['City'] ?? '') ?>,
        <?= esc($company['State'] ?? '') ?><br>
        <?= esc($company['Country'] ?? '') ?>
    </div>

    <h4>Contactos asociados</h4>

    <div class="tef-table">
        <table class="c-table">
            <thead>
                <tr>
                    <th>Nombre</th>
                    <th>Email</th>
                    <th>Teléfono</th>
                    <th style="text-align:right;">Acciones</th>
                </tr>
            </thead>
            <tbody>

            <?php if (empty($contacts)): ?>
                <tr>
                    <td colspan="4" class="text-muted text-center p-4">
                        No hay contactos asociados
                    </td>
                </tr>
            <?php else: ?>
                <?php foreach ($contacts as $contact): ?>
                    <tr>
                        <td><?= esc($contact['First_name'].' '.$contact['Last_name']) ?></td>
                        <td><?= esc($contact['Email']) ?></td>
                        <td><?= esc($contact['Phone'] ?? '-') ?></td>
                        <td style="text-align:right;">
                            <a href="<?= site_url('crm/contacts/view/'.$contact['PK_Contact']) ?>"
                               class="c-btn"
                               style="color:var(--tef-gold);">
                                <i class="fas fa-info-circle me-2"></i>
                            </a>
                        </td>
                    </tr>
                <?php endforeach ?>
            <?php endif ?>

            </tbody>
        </table>
    </div>

</div>

<?= $this->endSection() ?>
