<?= $this->extend('layouts/layout') ?>

<?= $this->section('titulo') ?>Contactos<?= $this->endSection() ?>

<?= $this->section('contenido') ?>

<div class="tef-panel">

    <!-- Header -->
    <div style="display:flex;justify-content:space-between;align-items:center;margin-bottom:20px;">
        <div>
            <h2 style="margin:0;">Contactos</h2>
            <p class="text-muted" style="margin:4px 0 0;">
                Gestiona tus contactos y continúa el flujo de cotización
            </p>
        </div>

        <a href="<?= site_url('crm/contacts/create') ?>"
           class="c-btn"
           style="padding:10px 16px;background:var(--tef-gold);color:#000;border-radius:10px;font-weight:600;">
            + Registrar contacto
        </a>
    </div>

    <!-- Tabla -->
    <div class="tef-table">
        <table class="c-table" id="contactsTable">
            <thead>
                <tr>
                    <th>Nombre</th>
                    <th>Email</th>
                    <th>Teléfono</th>
                    <th>Estado</th>
                    <th class="text-center">Acciones</th>
                </tr>
            </thead>

            <tbody>
            <?php if (empty($contacts)): ?>
                <tr>
                    <td colspan="5" class="text-muted" style="padding:20px;text-align:center;">
                        No hay contactos registrados
                    </td>
                </tr>
            <?php else: ?>
                <?php foreach ($contacts as $contact): ?>
                    <tr>
                        <td>
                            <b><?= esc($contact['First_name'].' '.$contact['Last_name']) ?></b>
                        </td>
                        <td><?= esc($contact['Email']) ?></td>
                        <td><?= esc($contact['Phone'] ?? '-') ?></td>
                        <td>
                            <?php
                                $statusClass = match($contact['Lifecycle_stage']) {
                                    'Cliente' => 'success',
                                    'En cotizacion' => 'info',
                                    default => 'danger'
                                };
                            ?>
                            <span class="tef-status <?= $statusClass ?>">
                                <?= esc($contact['Lifecycle_stage']) ?>
                            </span>
                        </td>
                        <td class="text-center">
                            <a href="<?= site_url('crm/contacts/view/'.$contact['PK_Contact']) ?>" class="btn btn-sm btn-outline-primary">
                                Ver
                            </a>
                        </td>
                        
                    </tr>
                <?php endforeach ?>
            <?php endif ?>
            </tbody>
        </table>
    </div>

</div>

<?= $this->endSection() ?>

<?= $this->section('scripts') ?>
<script>
$(document).ready(function () {
    $('#contactsTable').DataTable({
        pageLength: 25,
        lengthMenu: [10, 25, 50, 100],
        ordering: true,
        searching: true,
        info: true,
        language: {
            search: "Buscar:",
            lengthMenu: "Mostrar _MENU_ contactos",
            info: "Mostrando _START_ a _END_ de _TOTAL_ contactos",
            paginate: {
                previous: "Anterior",
                next: "Siguiente"
            },
            zeroRecords: "No se encontraron contactos"
        }
    });
});
</script>

<?= $this->endSection() ?>
