<?= $this->extend('layouts/layout') ?>

<?= $this->section('titulo') ?>
<?= esc($contact['First_name'].' '.$contact['Last_name']) ?>
<?= $this->endSection() ?>

<?= $this->section('contenido') ?>

<div class="tef-panel">

    <!-- HEADER -->
    <div style="display:flex;justify-content:space-between;align-items:flex-start;margin-bottom:24px;">
        <div>
            <h2 style="margin:0;">
                <?= esc($contact['First_name'].' '.$contact['Last_name']) ?>
            </h2>
            <p class="text-muted" style="margin:4px 0 0;">
                <?= esc($contact['Email']) ?>
            </p>
        </div>

        <?php
            $statusClass = match($contact['Lifecycle_stage']) {
                'Cliente' => 'success',
                'En cotización' => 'info',
                default => 'danger'
            };
        ?>
        <span class="tef-status <?= $statusClass ?>">
            <?= esc($contact['Lifecycle_stage']) ?>
        </span>
    </div>

    <div style="display:grid;grid-template-columns:320px 1fr;gap:20px;">

        <!-- SIDEBAR -->
        <div>

            <!-- DATOS -->
            <div class="tef-card" style="margin-bottom:16px;">
                <h4 class="tef-panel-title">Datos del contacto</h4>

                <p><b>Email:</b><br><?= esc($contact['Email']) ?></p>
                <p><b>Teléfono:</b><br><?= esc($contact['Phone'] ?? '-') ?></p>
                <p><b>Fecha alta:</b><br><?= date('d/m/Y', strtotime($contact['Created_at'])) ?></p>
            </div>

            <!-- EMPRESA -->
            <?php if (!empty($company)): ?>
            <div class="tef-card" style="margin-bottom:16px;">
                <h4 class="tef-panel-title">Empresa</h4>
                <p><b><?= esc($company['Name']) ?></b></p>
                <p class="text-muted"><?= esc($company['Industry'] ?? '-') ?></p>
            </div>
            <?php endif ?>

            <!-- ACCIONES -->
            <div class="tef-card">
                <h4 class="tef-panel-title">Acciones</h4>

                <a href="<?= site_url('crm/contacts/edit/'.$contact['PK_Contact']) ?>"
                    class="tef-btn tef-btn-secondary">
                    Editar contacto
                </a>
                <a href="<?= site_url('crm/contacts/'.$contact['PK_Contact'].'/quotes') ?>"
                    class="tef-btn tef-btn-muted">
                        Ver cotizaciones
                </a>

                <a href="<?= site_url('crm/quotes/create/'.$contact['PK_Contact']) ?>"
                    class="tef-btn tef-btn-primary">
                    Crear cotización
                </a>

            </div>

        </div>

        <!-- MAIN -->
        <div>

            <!-- TIMELINE -->
            <div class="tef-card">
                <h4 class="tef-panel-title">Actividad</h4>

                <ul class="activity-list">
                    <li><b>Contacto creado</b> <?= date('d/m/Y', strtotime($contact['Created_at'])) ?></li>
                    <?php if ($contact['Updated_at']): ?>
                        <li><b>Última actualización</b> <?= date('d/m/Y', strtotime($contact['Updated_at'])) ?></li>
                    <?php endif ?>
                </ul>
            </div>

        </div>

    </div>

</div>

<?= $this->endSection() ?>
