<?= $this->extend('layouts/layout') ?>

<?= $this->section('titulo') ?>Órdenes<?= $this->endSection() ?>

<?= $this->section('contenido') ?>

<!-- =========================
    PANEL ÓRDENES
========================= -->
<div class="tef-panel" style="margin-bottom:20px;">

    <div style="display:flex;justify-content:space-between;align-items:center;margin-bottom:20px;">
        <div>
            <h2 style="margin:0;">Órdenes</h2>
            <p class="text-muted" style="margin:4px 0 0;">
                Órdenes generadas desde cotizaciones
            </p>
        </div>
    </div>

    <table class="c-table" id="ordersTable">
        <thead>
            <tr>
                <th>Orden #</th>
                <th>Cotización #</th>
                <th>Cliente</th>
                <th>Destino</th>
                <th>Status</th>
                <th class="text-center">Acciones</th>
            </tr>
        </thead>

        <tbody>
        <?php if (empty($orders)): ?>
            <tr>
                <td colspan="6" style="padding:20px;text-align:center;opacity:.6;">
                    No hay órdenes registradas
                </td>
            </tr>
        <?php else: ?>
            <?php foreach ($orders as $order): ?>
            <tr>
                <td data-label="Orden #"><b><?= esc($order['Order_number']) ?></b></td>
                <td data-label="Cotización"><?= esc($order['Quote_number']) ?></td>
                <td data-label="Cliente"><?= esc($order['Destination_name']) ?></td>
                <td data-label="Destino">
                    <?= esc($order['Destination_city'].', '.$order['Destination_state']) ?>
                </td>

                <td data-label="Status">
                    <?php
                    $statusClass = match($order['Status']) {
                        'Procesando' => 'info',
                        'Entregada'  => 'success',
                        'Cancelada'  => 'danger',
                        default      => 'muted'
                    };
                    ?>
                    <span class="tef-status <?= $statusClass ?>">
                        <?= esc($order['Status']) ?>
                    </span>
                </td>

                <td data-label="Acciones" class="text-center">
                    <a href="<?= site_url('crm/orders/view/'.$order['PK_Order']) ?>"
                       class="tef-btn tef-btn-primary"
                       style="padding:6px 10px;font-size:12px;">
                        Ver
                    </a>
                </td>
            </tr>
            <?php endforeach ?>
        <?php endif ?>
        </tbody>
    </table>

</div>


<!-- =========================
    PANEL APARTADOS
========================= -->
<div class="tef-panel">

    <div style="display:flex;justify-content:space-between;align-items:center;margin-bottom:20px;">
        <div>
            <h2 style="margin:0;">Apartados</h2>
            <p class="text-muted" style="margin:4px 0 0;">
                Órdenes en estado de apartado / con abono
            </p>
        </div>
    </div>

    <table class="c-table" id="apartadosTable">
        <thead>
            <tr>
                <th>Orden #</th>
                <th>Cotización #</th>
                <th>Cliente</th>
                <th>Destino</th>
                <th>Balance</th>
                <th>Status</th>
                <th class="text-center">Acciones</th>
            </tr>
        </thead>

        <tbody>
        <?php if (empty($apartados)): ?>
            <tr>
                <td colspan="7" style="padding:20px;text-align:center;opacity:.6;">
                    No hay apartados registrados
                </td>
            </tr>
        <?php else: ?>
            <?php foreach ($apartados as $apartado): ?>
            <tr>
                <td data-label="Orden #"><b><?= esc($apartado['Apartado_number']) ?></b></td>
                <td data-label="Cotización"><?= esc($apartado['Quote_number']) ?></td>
                <td data-label="Cliente"><?= esc($apartado['Destination_name']) ?></td>

                <td data-label="Destino">
                    <?= esc($apartado['Destination_city'].', '.$apartado['Destination_state']) ?>
                </td>

                <td data-label="Pendiente">
                    <?= esc($apartado['Currency'] ?? '$') ?>
                    <?= number_format((float)($apartado['Balance'] ?? 0), 2) ?>
                </td>

                <td data-label="Status">
                    <span class="tef-status danger">
                        Apartado
                    </span>
                </td>

                <td data-label="Acciones" class="text-center">
                    <a href="<?= site_url('crm/apartados/view/'.$apartado['PK_Apartado']) ?>"
                       class="tef-btn tef-btn-secondary"
                       style="padding:6px 10px;font-size:12px;">
                        Gestionar Pago
                    </a>
                </td>
            </tr>
            <?php endforeach ?>
        <?php endif ?>
        </tbody>
    </table>

</div>

<?= $this->endSection() ?>

<?= $this->section('scripts') ?>
<script>
$(function () {

    $('#ordersTable').DataTable({
        pageLength: 10,
        language: {
            search: "Buscar:",
            lengthMenu: "Mostrar _MENU_",
            info: "_START_ a _END_ de _TOTAL_",
            paginate: { previous: "←", next: "→" }
        }
    });

    $('#apartadosTable').DataTable({
        pageLength: 10,
        language: {
            search: "Buscar:",
            lengthMenu: "Mostrar _MENU_",
            info: "_START_ a _END_ de _TOTAL_",
            paginate: { previous: "←", next: "→" }
        }
    });

});
</script>
<?= $this->endSection() ?>
