<?= $this->extend('layouts/layout') ?>

<?= $this->section('titulo') ?>Orden de Envío<?= $this->endSection() ?>

<?= $this->section('contenido') ?>
<?php $isLiquidado = ((float)($balance['Balance'] ?? 0) <= 0); ?>
<div class="tef-card" style="margin: 20px auto;">

    <!-- Header con botón PDF -->
    <div style="display:flex; justify-content: space-between; align-items:center; margin-bottom: 20px;">
        <div class="tef-panel-title" style="font-size: 22px;">
            Orden de Envío #<?= $order['Order_number'] ?? '12345' ?>
        </div>
        <div class="tef-dropdown">
                <button class="tef-btn tef-btn-primary">
                    Descargar PDF ▾
                </button>

                <div class="tef-dropdown-menu">
                    <a href="<?= site_url('crm/quotes/pdf/'.$order['FK_Quote'].'?lang=es') ?>"
                    target="_blank">
                        Español
                    </a>
                    <a href="<?= site_url('crm/quotes/pdf/'.$order['FK_Quote'].'?lang=en') ?>"
                    target="_blank">
                        English
                    </a>
                </div>
            </div>
    </div>

    <!-- Timeline horizontal -->
    <div class="tef-panel" style="margin-bottom:20px;">
        <div class="tef-panel-title">Progreso del Envío</div>
        <div style="display:flex; justify-content: space-between; align-items: center; padding: 10px 0; position:relative;">
            <?php 
            $timeline = [
                ['title'=>'Orden Confirmada','date'=>'26 Ene','status'=>'success'],
                ['title'=>'Recolectado','date'=>'26 Ene','status'=>'success'],
                ['title'=>'En tránsito','date'=>'26 Ene','status'=>'info'],
                ['title'=>'Entrega programada','date'=>'28 Ene','status'=>'danger'],
                ['title'=>'Entregado','date'=>'--','status'=>'muted'],
            ];
            $count = count($timeline);
            foreach($timeline as $i=>$step): 
                $color = match($step['status']) {
                    'success' => '#1f7a4f',
                    'info' => '#3a6ea5',
                    'danger' => '#a53a3a',
                    'muted' => '#555',
                };
            ?>
            <div style="flex:1; text-align:center; position:relative;">
                <div style="width:18px; height:18px; border-radius:50%; background: <?= $color ?>; margin:0 auto; z-index:2; position:relative;"></div>
                <?php if($i < $count-1): ?>
                <div style="position:absolute; top:8px; left:50%; width:100%; height:2px; background:#444; z-index:1;"></div>
                <?php endif; ?>
                <div style="font-size:12px; margin-top:6px;"><?= $step['title'] ?><br><small><?= $step['date'] ?></small></div>
            </div>
            <?php endforeach; ?>
        </div>
    </div>

    <!-- Detalles de la orden en columnas -->
    <div class="tef-panel" style="margin-bottom:20px;">
        <div class="tef-panel-title">Detalles de la Orden</div>
        <div style="display:flex; flex-wrap:wrap; gap:20px;">

            <!-- Columna 1: Remitente -->
            <div style="flex:1 1 200px;">
                <ul class="activity-list">
                    <li><b>Remitente:</b> <?= $order['Origin_name'] ?? 'Juan Pérez' ?></li>
                    <li><b>Teléfono:</b> <?= $order['Origin_phone'] ?? '+52 55 1234 5678' ?></li>
                    <li><b>Dirección:</b> <?= $order['Origin_address'] ?? 'Calle 45 #123, Ciudad, CP 45678' ?></li>
                </ul>
            </div>

            <!-- Columna 2: Destinatario -->
            <div style="flex:1 1 200px;">
                <ul class="activity-list">
                    <li><b>Destinatario:</b> <?= $order['Destination_name'] ?? 'María López' ?></li>
                    <li><b>Teléfono:</b> <?= $order['Destination_phone'] ?? '+52 55 8765 4321' ?></li>
                    <li><b>Dirección:</b> <?= $order['Destination_address'] ?? 'Av. Central 789, Ciudad, CP 12345' ?></li>
                </ul>
            </div>

            <!-- Columna 3: Detalles del envío -->
            <div style="flex:1 1 200px;">
                <ul class="activity-list">
                    <li><b>Fecha de envío:</b> <?= $order['Created_at'] ?? '26 Ene 2026' ?></li>
                    <li><b>Fecha estimada de entrega:</b> <?= $order['Estimated_delivery'] ?? '28 Ene 2026' ?></li>
                    <li><b>Peso total:</b> <?= $order['Weight_kg'] ?? '3 kg' ?></li>
                    <li><b>Dimensiones:</b> <?= $order['Length_cm'] ?? '30' ?>x<?= $order['Width_cm'] ?? '20' ?>x<?= $order['Height_cm'] ?? '15' ?> cm</li>
                    <li><b>Valor declarado:</b> <?= $order['Currency'] ?? '$' ?><?= $order['Declared_value'] ?? '500' ?></li>
                    <li><b>Costo total:</b> <?= $order['Currency'] ?? '$' ?><?= $order['Total_amount'] ?? '450' ?></li>
                    <li><b>Comentarios:</b> <?= $order['Comments'] ?? 'Ninguno' ?></li>
                </ul>
            </div>

        </div>
    </div>

    <!-- Estado actual + actualizar -->
    <div style="display:flex; gap:20px; flex-wrap:wrap; margin-bottom:20px;">
        <div style="flex:1 1 300px;">
            <div class="tef-panel">
                <div class="tef-panel-title">Estado Actual</div>
                <ul class="activity-list">
                    <li><b>Status:</b> <?= $order['Status'] ?? 'En tránsito' ?></li>
                    <li><b>Paquetería:</b> <?= $order['Courier'] ?? 'DHL Express' ?></li>
                    <li><b>Número de seguimiento:</b> <?= $order['Tracking_number'] ?? 'DHL123456789MX' ?></li>
                    <li><b>Ubicación actual:</b> <?= $order['Current_location'] ?? 'Centro de distribución CDMX' ?></li>
                    <li><b>Última actualización:</b> <?= $order['Status_updated_at'] ?? '26 Ene 2026 14:35' ?></li>
                </ul>
            </div>
        </div>
        <div style="flex:1 1 300px;">
            <div class="tef-panel">
                <div class="tef-panel-title">Actualizar Estado</div>
                <div class="tef-input-group">
                    <label for="update-status">Selecciona nuevo estado</label>
                    <select id="update-status" class="tef-select">
                        <option value="en_transito">En tránsito</option>
                        <option value="entregado">Entregado</option>
                        <option value="retrasado">Retrasado</option>
                        <option value="cancelado">Cancelado</option>
                    </select>
                    <button class="tef-btn tef-btn-primary">Actualizar</button>
                </div>
            </div>
        </div>
    </div>

    <!-- Tabla de servicios -->
    <div class="tef-panel" style="margin-bottom:20px; overflow-x:auto;">
        <div class="tef-panel-title">Servicios</div>
        <table class="c-table" style="min-width: 600px;">
            <thead>
                <tr>
                    <th>Servicio</th>
                    <th>Cantidad</th>
                    <th>Precio Unitario</th>
                    <th>Total</th>
                    <th>Status</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach($services as $service): ?>
                <tr>
                    <td><?= $service['Service_name'] ?></td>
                    <td><?= $service['Quantity'] ?></td>
                    <td><?= $order['Currency'] ?? '$' ?><?= $service['Unit_price'] ?></td>
                    <td><?= $order['Currency'] ?? '$' ?><?= $service['Total'] ?></td>
                    <td>
                        <?php
                        $status = strtolower($service['Status'] ?? 'pendiente');
                        $status_class = match($status) {
                            'completo' => 'success',
                            'activo' => 'info',
                            'pendiente' => 'danger',
                            default => 'muted'
                        };
                        ?>
                        <span class="tef-status <?= $status_class ?>"><?= ucfirst($status) ?></span>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>

    <!-- Pagos en dos columnas fijas -->
<div style="display:flex; gap:20px;">

        <div class="tef-panel" style="flex:1;">
        <div class="tef-panel-title">Registrar Pago</div>
        <?php if ($isLiquidado): ?>
            <div class="tef-alert success" style="margin-bottom:12px;">
                ✔ Orden liquidada — no se permiten más pagos
            </div>
        <?php endif; ?>

        <form method="post"
            action="<?= site_url('crm/payments/store') ?>">

            <?= csrf_field() ?>

            <input type="hidden"
                name="FK_Quote"
                value="<?= esc($order['FK_Quote']) ?>">

            <div class="tef-input-group">
                <label>Monto</label>
                <input type="number"
                    name="amount"
                    step="0.01"
                    required
                    class="tef-input"
                    placeholder="0.00"
                    <?= $isLiquidado ? 'disabled' : '' ?>>
            </div>

            <div class="tef-input-group">
                <label>Método de pago</label>
                <select name="payment_method"
                        required
                        class="tef-select"
                        <?= $isLiquidado ? 'disabled' : '' ?>>
                    <option value="">Seleccionar…</option>
                    <option>Efectivo</option>
                    <option>Tarjeta</option>
                    <option>Transferencia</option>
                    <option>Depósito</option>
                    <option>Cheque</option>
                </select>
            </div>

            <div class="tef-input-group">
                <label>Referencia</label>
                <input type="text"
                    name="reference"
                    class="tef-input"
                    placeholder="Folio / operación"
                    <?= $isLiquidado ? 'disabled' : '' ?>>
            </div>

            <div class="tef-input-group">
                <label>Notas</label>
                <textarea name="notes"
                        class="tef-textarea"
                        rows="2"
                        <?= $isLiquidado ? 'disabled' : '' ?>></textarea>
            </div>

            <button class="tef-btn tef-btn-success"
                    style="margin-top:12px;"
                    <?= $isLiquidado ? 'disabled' : '' ?>>
                <?= $isLiquidado ? 'Pagado ✓' : 'Registrar Pago' ?>
            </button>

        </form>
    </div>
    
    <div class="tef-panel" style="flex:1;">
        <div class="tef-panel-title">Historial de Pagos</div>

        <table class="c-table">
            <thead>
                <tr>
                    <th>Fecha</th>
                    <th>Método</th>
                    <th>Tipo</th>
                    <th>Referencia</th>
                    <th style="text-align:right;">Monto</th>
                </tr>
            </thead>

            <tbody>

            <?php if (!empty($payments)): ?>
                <?php foreach ($payments as $p): ?>
                    <tr>
                        <td data-label="Fecha">
                            <?= !empty($p['Paid_at'])
                                ? date('d/m/Y H:i', strtotime($p['Paid_at']))
                                : '—' ?>
                        </td>

                        <td data-label="Método">
                            <?= esc($p['Payment_method']) ?>
                        </td>

                        <td data-label="Tipo">
                            <span class="tef-status <?= 
                                ($p['Payment_type']=='Contado') ? 'success' :
                                (($p['Payment_type']=='Parcial') ? 'info' : 'danger')
                            ?>">
                                <?= esc($p['Payment_type'] ?? '—') ?>
                            </span>
                        </td>

                        <td data-label="Referencia">
                            <?= esc($p['Reference'] ?: '—') ?>
                        </td>

                        <td data-label="Monto" style="text-align:right;">
                            <?= esc($order['Currency']) ?>
                            <?= number_format((float)$p['Amount'], 2) ?>
                        </td>
                    </tr>
                <?php endforeach; ?>

            <?php else: ?>

                <tr>
                    <td colspan="5" style="opacity:.6; text-align:center;">
                        No hay pagos registrados
                    </td>
                </tr>

            <?php endif; ?>

            </tbody>
        </table>

        <hr style="margin:14px 0; opacity:.2;">

        <!-- RESUMEN -->
        <table class="c-table">
            <tbody>
                <tr>
                    <td>Total</td>
                    <td style="text-align:right;">
                        <?= esc($order['Currency']) ?>
                        <?= number_format((float)$balance['Total_amount'], 2) ?>
                    </td>
                </tr>

                <tr>
                    <td>Pagado</td>
                    <td style="text-align:right;">
                        <?= esc($order['Currency']) ?>
                        <?= number_format((float)$balance['Paid_amount'], 2) ?>
                    </td>
                </tr>

                <tr>
                    <td>Pendiente</td>
                    <td style="text-align:right;">
                        <?= esc($order['Currency']) ?>
                        <?= number_format((float)$balance['Balance'], 2) ?>
                    </td>
                </tr>

                <tr>
                    <td>Estado</td>
                    <td style="text-align:right;">
                        <span class="tef-status <?= $balance['Balance'] <= 0 ? 'success' : 'danger' ?>">
                            <?= esc($balance['Payment_status']) ?>
                        </span>
                    </td>
                </tr>
            </tbody>
        </table>

    </div>


</div>
<?= $this->endSection() ?>

<?= $this->section('scripts') ?>
<?php if ($order['Status'] === 'Apartado'): ?>

<div class="tef-alert">
    Orden en estado APARTADO — solo módulo de pagos habilitado
</div>

<script>
document.querySelectorAll('.module-button').forEach(btn => {
    if (!btn.classList.contains('payments-only')) {
        btn.disabled = true;
        btn.style.opacity = .4;
    }
});
</script>

<?php endif; ?>

<?php if ($isLiquidado): ?>
<script>
document.querySelector('form[action*="payments/store"]')
?.addEventListener('submit', function(e){
    e.preventDefault();
    alert('La orden ya está liquidada');
});
</script>
<?php endif; ?>

<?php if (session()->getFlashdata('swal')): ?>
<script>
Swal.fire({
    icon: "<?= session('swal.icon') ?>",
    title: "<?= session('swal.title') ?>",
    text: "<?= session('swal.text') ?>",
    confirmButtonColor: "#1f7a4f"
});
</script>
<?php endif; ?>

<?= $this->endSection() ?>
