<?= $this->extend('layouts/layout') ?>

<?= $this->section('titulo') ?>
Cotizaciones | TEF
<?= $this->endSection() ?>

<?= $this->section('contenido') ?>

<div class="tef-panel">

    <div style="display:flex;justify-content:space-between;align-items:center;margin-bottom:20px;">
        <div>
            <h2 style="margin:0;">Cotizaciones</h2>
            <p class="text-muted" style="margin:4px 0 0;">
                Gestiona tus cotizaciones y continúa el flujo de cotización
            </p>
        </div>
    </div>

    <div class="table-responsive tef-table">
        <table id="quotesTable" class="c-table">
            <thead>
                <tr>
                    <th>Referencia</th>
                    <th>Cliente</th>
                    <th>Empresa</th>
                    <th>Servicio</th>
                    <th>Destino</th>
                    <th>Total</th>
                    <th>Estado</th>
                    <th>Fecha</th>
                    <th style="width:120px;">Acciones</th>
                </tr>
            </thead>

            <tbody>
            <?php if (!empty($quotes)): ?>
                <?php foreach ($quotes as $quote): ?>
                    <tr>
                        <td>
                            <strong><?= esc($quote['Quote_number']) ?></strong>
                        </td>

                        <td>
                            <?= esc($quote['Contact_name']) ?><br>
                            <small class="text-muted">
                                <?= esc($quote['Email']) ?>
                            </small>
                        </td>

                        <td>
                            <?= esc($quote['Company_name'] ?? '—') ?>
                        </td>

                        <td>
                            <?= esc($quote['Service_type']) ?>
                        </td>

                        <td>
                            <?= esc($quote['Destination_city']) ?><br>
                            <small class="text-muted">
                                <?= esc($quote['Destination_country']) ?>
                            </small>
                        </td>

                        <td>
                            <strong>
                                <?= esc($quote['Currency']) ?>
                                <?= number_format($quote['Total_amount'], 2) ?>
                            </strong>
                        </td>

                        <td>
                            <?php
                                $badgeClass = match ($quote['Status']) {
                                    'Cotizacion'     => 'badge bg-primary',
                                    'Orden de Envio' => 'badge bg-success',
                                    'Expirada'       => 'badge bg-danger',
                                    default          => 'badge bg-secondary'
                                };
                            ?>
                            <span class="<?= $badgeClass ?>">
                                <?= esc($quote['Status']) ?>
                            </span>
                        </td>

                        <td>
                            <?= date('d/m/Y', strtotime($quote['Quoted_at'])) ?>
                        </td>

                        <td>
                            <a href="<?= base_url('crm/quotes/view/' . $quote['PK_Quote']) ?>"
                            class="btn btn-sm btn-outline-primary">
                                Ver
                            </a>
                            <a href="<?= base_url('crm/quotes/edit/' . $quote['PK_Quote']) ?>"
                                class="btn btn-sm btn-outline-warning">
                                Editar
                            </a>

                            <button
                                type="button"
                                class="btn btn-sm btn-outline-danger"
                                onclick="deleteQuote(<?= $quote['PK_Quote'] ?>)">
                                Borrar
                            </button>

                        </td>
                    </tr>
                <?php endforeach; ?>
            <?php else: ?>
                <tr>
                    <td colspan="9" class="text-center text-muted">
                        No hay cotizaciones registradas
                    </td>
                </tr>
            <?php endif; ?>
            </tbody>
        </table>
        <form id="delete-quote-form" method="post" style="display:none;">
            <?= csrf_field() ?>
            <input type="hidden" name="_method" value="DELETE">
        </form>

    </div>

</div>

<?= $this->endSection() ?>
<?= $this->section('scripts') ?>

<script>
$(document).ready(function () {
    $('#quotesTable').DataTable({
        pageLength: 25,
        lengthMenu: [10, 25, 50, 100],
        ordering: true,
        searching: true,
        info: true,
        language: {
            search: "Buscar:",
            lengthMenu: "Mostrar _MENU_ cotizaciones",
            info: "Mostrando _START_ a _END_ de _TOTAL_ cotizaciones",
            paginate: {
                previous: "Anterior",
                next: "Siguiente"
            },
            zeroRecords: "No se encontraron cotizaciones"
        }
    });
});
</script>

<script>
function deleteQuote(id) {

    Swal.fire({
        title: '¿Eliminar cotización?',
        text: 'Esta acción no se puede deshacer',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#d33',
        cancelButtonColor: '#666',
        confirmButtonText: 'Sí, eliminar',
        cancelButtonText: 'Cancelar'
    }).then((result) => {
        if (result.isConfirmed) {

            const form = document.getElementById('delete-quote-form');
            form.action = `<?= base_url('crm/quotes/delete/') ?>${id}`;
            form.submit();
        }
    });
}
</script>

<?php if (session()->getFlashdata('success')): ?>
<script>
Swal.fire({
    icon: 'success',
    title: 'Éxito',
    text: '<?= esc(session()->getFlashdata('success')) ?>',
    confirmButtonColor: '#C6A34F'
});
</script>
<?php endif; ?>

<?php if (session()->getFlashdata('error')): ?>
<script>
Swal.fire({
    icon: 'error',
    title: 'Error',
    text: '<?= esc(session()->getFlashdata('error')) ?>',
    confirmButtonColor: '#d33'
});
</script>
<?php endif; ?>

<?php if (session()->getFlashdata('warning')): ?>
<script>
Swal.fire({
    icon: 'warning',
    title: 'Atención',
    text: '<?= esc(session()->getFlashdata('warning')) ?>',
    confirmButtonColor: '#C6A34F'
});
</script>
<?php endif; ?>



<?= $this->endSection() ?>