<?= $this->extend('layouts/layout') ?>

<?= $this->section('titulo') ?>
Cotizaciones de <?= esc($contact['First_name']) ?>
<?= $this->endSection() ?>

<?= $this->section('contenido') ?>

<div class="tef-panel">

    <div style="display:flex;justify-content:space-between;align-items:center;margin-bottom:20px;">
        <div>
            <h2 style="margin:0;">
                Cotizaciones – <?= esc($contact['First_name'].' '.$contact['Last_name']) ?>
            </h2>
            <p class="text-muted" style="margin:4px 0 0;">
                Historial de cotizaciones del contacto
            </p>
        </div>
    </div>

    <div class="table-responsive tef-table">
        <table id="contactQuotesTable" class="c-table">
            <thead>
                <tr>
                    <th>Referencia</th>
                    <th>Fecha</th>
                    <th>Total</th>
                    <th>Estado</th>
                    <th style="width:140px;">Acciones</th>
                </tr>
            </thead>
            <tbody>

            <?php if (empty($quotes)): ?>
                <tr>
                    <td colspan="5" class="text-center text-muted">
                        No hay cotizaciones aún
                    </td>
                </tr>
            <?php else: ?>

                <?php foreach ($quotes as $q): ?>
                    <tr>
                        <td>
                            <strong><?= esc($q['Quote_number']) ?></strong>
                        </td>

                        <td>
                            <?= date('d/m/Y', strtotime($q['Created_at'])) ?>
                        </td>

                        <td>
                            <strong>
                                <?= esc($q['Currency']) ?>
                                <?= number_format($q['Total_amount'], 2) ?>
                            </strong>
                        </td>

                        <td>
                            <?php
                                $badgeClass = match ($q['Status']) {
                                    'Cotizacion'     => 'badge bg-primary',
                                    'Orden de Envio' => 'badge bg-success',
                                    'Expirada'       => 'badge bg-danger',
                                    default          => 'badge bg-secondary'
                                };
                            ?>
                            <span class="<?= $badgeClass ?>">
                                <?= esc($q['Status']) ?>
                            </span>
                        </td>

                        <td>
                            <a href="<?= site_url('crm/quotes/view/'.$q['PK_Quote']) ?>"
                               class="btn btn-sm btn-outline-primary">
                                Ver
                            </a>

                            
                                <button
                                    type="button"
                                    class="btn btn-sm btn-outline-danger"
                                    onclick="deleteQuote(<?= $q['PK_Quote'] ?>)">
                                    Borrar
                                </button>
                        </td>
                    </tr>
                <?php endforeach ?>

            <?php endif; ?>

            </tbody>
        </table>
    </div>

    <!-- FORM OCULTO PARA DELETE -->
    <form id="delete-quote-form" method="post" style="display:none;">
        <?= csrf_field() ?>
        <input type="hidden" name="_method" value="DELETE">
    </form>

</div>

<?= $this->endSection() ?>

<?= $this->section('scripts') ?>
<script>
$(document).ready(function () {
    $('#contactQuotesTable').DataTable({
        pageLength: 10,
        ordering: true,
        searching: true,
        info: true,
        language: {
            search: "Buscar:",
            lengthMenu: "Mostrar _MENU_ cotizaciones",
            info: "Mostrando _START_ a _END_ de _TOTAL_ cotizaciones",
            paginate: {
                previous: "Anterior",
                next: "Siguiente"
            },
            zeroRecords: "No se encontraron cotizaciones"
        }
    });
});
</script>

<script>
function deleteQuote(id) {
    Swal.fire({
        title: '¿Eliminar cotización?',
        text: 'Esta acción no se puede deshacer',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#d33',
        cancelButtonColor: '#666',
        confirmButtonText: 'Sí, eliminar',
        cancelButtonText: 'Cancelar'
    }).then((result) => {
        if (result.isConfirmed) {
            const form = document.getElementById('delete-quote-form');
            form.action = `<?= base_url('crm/quotes/delete/') ?>${id}`;
            form.submit();
        }
    });
}
</script>


<?php if (session()->getFlashdata('success')): ?>
<script>
Swal.fire({
    icon: 'success',
    title: 'Éxito',
    text: '<?= esc(session()->getFlashdata('success')) ?>',
    confirmButtonColor: '#C6A34F'
});
</script>
<?php endif; ?>

<?php if (session()->getFlashdata('error')): ?>
<script>
Swal.fire({
    icon: 'error',
    title: 'Error',
    text: '<?= esc(session()->getFlashdata('error')) ?>',
    confirmButtonColor: '#d33'
});
</script>
<?php endif; ?>

<?php if (session()->getFlashdata('warning')): ?>
<script>
Swal.fire({
    icon: 'warning',
    title: 'Atención',
    text: '<?= esc(session()->getFlashdata('warning')) ?>',
    confirmButtonColor: '#C6A34F'
});
</script>
<?php endif; ?>

<?= $this->endSection() ?>
