<!DOCTYPE html>
<?php
$logoPath = FCPATH . 'img/logo-tef-pdf.jpg';

$logoBase64 = '';
if (file_exists($logoPath)) {
    $type = pathinfo($logoPath, PATHINFO_EXTENSION); // png o jpg
    $data = file_get_contents($logoPath);
    $logoBase64 = 'data:image/' . $type . ';base64,' . base64_encode($data);
}
?>

<html lang="es">
<head>
<meta charset="UTF-8">

<style>
body {
    font-family: DejaVu Sans, sans-serif;
    color:#111;
}

.cover {
    text-align:center;
    margin-top:100px;
}

.cover h1 {
    font-size:24px;
    font-weight:700;
    margin-top:100px;
    margin-bottom:10px;
}

.cover em {
    font-size:12px;
    color:#555;
}

.cover {
    margin-top:100px;
    font-size:11px;
    color:#333;
}

.meta {
    width: 100%;
    text-align: left;
    font-size: 11px;
    margin-bottom: 20px;
    margin-top: 20px;
}

.meta-comments {
    width: 100%;
    text-align: left;
    font-size: 11px;
    margin-bottom: 20px;
    margin-top: 20px;
    border: 1px solid #000000ff;
}

.meta-comments span{
    padding: 10px;
}

.info-grid {
    width: 100%;
    margin-bottom: 25px;
    border-collapse: collapse;
}

.info-grid td {
    width: 50%;
    vertical-align: top;
    padding: 10px;
}

.info-block {
    font-size: 12px;
    line-height: 1.5;
}

.info-block.left {
    text-align: left;
}

.info-block.right {
    text-align: right;
}

.label {
    color: #666;
    font-weight: bold;
}

.total-row {
    width: 50%;
    height: 20px;
    margin-top: 25px;
    padding-bottom: 6px;
    border-bottom: 1px solid #000000ff; /* azul oscuro elegante */
    font-size: 14px;
    font-weight: bold;
    
}

.total-label {
    float: left;
}

.total-label, .total-amount{
    font-size:11px;
}

.total-amount {
    float: right;
}

.section-box {
    margin-top: 30px;
    border: 1px solid #1f3a5f;
}

.section-title {
    padding: 10px;
    font-weight: bold;
    font-size: 11px;
    color: #1f3a5f;
    border-bottom: 1px solid #1f3a5f;
}

.services-table {
    width: 100%;
    border-collapse: collapse;
}

.services-table th,
.services-table td {
    padding: 10px;
    font-size: 11px;
}

.services-table thead th {
    border-bottom: 1px solid #1f3a5f;
    color: #1f3a5f;
}

.services-table tbody tr:not(:last-child) td {
    border-bottom: 1px solid #ddd;
}

.summary-table {
    width: 100%;
    border-collapse: collapse;
}

.summary-table td {
    padding: 10px;
    font-size: 11px;
}

.total-table {
    width: 100%;
    margin-top: 15px;
    border-collapse: collapse;
}

.total-table td {
    padding: 12px;
    font-weight: bold;
    font-size: 12px;
    border: 1px solid #1f3a5f;
}

.total-table td:first-child {
    width: 70%;
    text-align: right;
}

.total-table td:last-child {
    text-align: right;
}

.insurance-text {
    padding: 12px;
    font-size: 10.5px;
    line-height: 1.5;
    color: #000;
}

.insurance-text p {
    margin: 0 0 10px 0;
}

.insurance-text ol {
    margin: 8px 0 12px 18px;
    padding: 0;
}

.insurance-text li {
    margin-bottom: 8px;
}

.insurance-contact {
    margin-top: 10px;
    font-size: 10.5px;
}

.text-header{
    color: #33475b;
}

.text-normal{
    color: #33475b;
}
.header-title{
    font-size: 14px;
}


</style>
</head>

<body>


<h1 class="info-block right text-normal">
<?php if ($quote['Status'] === 'Apartado' && $quote['PK_Apartado']): ?>
    <strong><?= esc($quote['Apartado_order']) ?></strong>
<?php endif; ?>

<?php if ($quote['Status'] === 'Orden de Envio' && $quote['PK_Order']): ?>
    <strong><?= esc($quote['Order_number']) ?></strong>
<?php endif; ?>
<?php if ($quote['Status'] === 'Cotizacion'): ?>
    <?= esc($quote['Quote_number']) ?>
<?php endif; ?>
</h1>
<div class="cover"> 
    

    <?php if ($logoBase64): ?>
        <img src="<?= $logoBase64 ?>" >
    <?php endif; ?>

    <h1 class="text-normal">
        <?= esc($quote['Company_name']) ?>
        <?= esc($services[0]['Service_name'] ?? '') ?>
        <?= esc($quote['Destination_name']) ?>
    </h1>

    <em class="text-normal">"Don't stress over something so simple."</em>

    <div class="meta text-normal">
        San Miguel de Allende, Gto <?= date('F j, Y', strtotime($quote['Quoted_at'])) ?>
    </div>
    <div class="meta text-normal">
        Transporte Envío Fácil (TEF) Pipila 14. Nuevo Pantoja, Libramiento Manuel Zavala.
    </div>
    <div class="meta text-normal">
        <strong><?= esc($quote['Status']) ?></strong>
    </div>
    
</div>

<table class="info-grid">
    <tr>
        <!-- TEF -->
        <td class="info-block left text-normal">
            <strong class="text-header">Transporte Envío Fácil</strong><br>
            Ignacio Allende 85<br>
            Colonia San Rafael<br>
            San Miguel de Allende, Guanajuato 37730<br>
            Mexico<br><br>

            tefenvios@gmail.com<br>
            +52 415 103 1150
        </td>

        <!-- CLIENTE -->
        <td class="info-block right text-normal">
            <strong class=" text-normal"><?= esc($quote['Destination_name']) ?></strong> <br>
            <?= esc($quote['Destination_phone']) ?><br>
            <?= esc($quote['Destination_address'] . ', ' .$quote['Destination_city']. ', '.$quote['Destination_state'] . ' '. $quote['Destination_zip']) ?><br>
            <?= esc($quote['Destination_country'])?><br><br>

            <strong class="text-header"><?= esc($quote['Company_name']) ?></strong><br>
            <?= esc($quote['Company_phone']) ?><br>
            <?= esc($quote['Company_address']) ?><br>
            <?= esc($quote['Company_zip'] . ' ' .$quote['Company_city']) ?><br>
            <?= esc($quote['Company_state']) ?>

        </td>
    </tr>
</table>

<div>
    <?php if ($quote['Status'] == 'Cotizacion'): ?>
        <span class="total-label text-header"><strong>Expiration Date:</strong> <?= date('F j, Y', strtotime($quote['Expires_at'])) ?></span>
    <?php endif; ?>
</div>

<div class="total-row">
    <span class="total-label text-header">Total</span>
    <span class="total-amount text-header">
        <?= esc($quote['Currency']) ?> $<?= number_format($quote['Total_amount'], 2) ?>
    </span>
</div>

<div class="section-box">

    <table class="services-table">
        <thead>
            <tr>
                <th style="text-align:left;">Products & Services</th>
                <th style="width:80px;text-align:center;">Quantity</th>
                <!-- <th style="width:120px;text-align:right;">Price</th> -->
            </tr>
        </thead>
        <tbody>
            <?php foreach ($services as $service): ?>
                <tr class="text-normal">
                    <td><?= esc($service['Service_name']) ?></td>
                    <td style="text-align:center;">
                        <?= number_format($service['Quantity'], 0) ?>
                    </td>
                    <!-- <td style="text-align:right;">
                        <?= esc($quote['Currency']) ?>
                        <?= number_format($service['Total'], 2) ?>
                    </td> -->
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>

<div class="section-box" style="margin-top:20px;">
    <div class="section-title">SUMMARY</div>

    <table class="summary-table text-normal">
        <tr>
            <td>One-time subtotal</td>
            <td style="text-align:right;">
                <?= esc($quote['Currency']) ?>
                <?= number_format($quote['Subtotal'], 2) ?>
            </td>
        </tr>
    </table>
</div>

<table class="total-table text-normal">
    <tr>
        <td>Total</td>
        <td>
            <?= esc($quote['Currency']) ?>
            <?= number_format($quote['Total_amount'], 2) ?>
        </td>
    </tr>
</table>

<div class="meta-comments text-header">
    <div class="insurance-text text-header header-title"><strong>Comments</strong></div>
    <span><?= esc($quote['Comments']) ?></span>
</div>

<div class="section-box" style="margin-top:30px;">
    <div class="insurance-text text-header header-title"><strong>Insurance Terms and Conditions</strong></div>

    <div class="insurance-text text-normal">
        <p>
            The insurance applies in case of loss, misplacement, or damage to the shipped merchandise.
            To file an insurance claim with <strong class="text-header">Transportes Envío Fácil</strong>, please follow the attached
            instructions <strong class="text-header">CAREFULLY</strong>:
        </p>

        <p>
            You have <strong class="text-header">72 hours</strong> after receiving your shipment to file a claim; otherwise,
            the insurance will not be valid. Therefore, we recommend doing so as soon as possible.
        </p>

        <p>
            All insurance-related communication must be directed to <strong class="text-header">(TEF)</strong> to avoid interfering
            with the process.
        </p>

        <p>
            If the damaged item can be repaired, only the repair costs will be covered, which must be supported
            by a receipt or quotation, or a repair kit will be provided.
        </p>

        <p><strong class="text-header header-title">Steps to follow to file a claim:</strong></p>

        <ol>
            <li>
                Send an email with at least <strong class="text-header">7 photos</strong> and <strong class="text-header">2 videos</strong> of the package,
                showing the damage to the outer box and the affected item(s), to <strong class="text-header">(TEF)</strong>.
                Include a brief description of the damage, the unpacking process, your name, and your contact
                information.<br>
                Contact email: <strong class="text-header">info@tefenvios.com</strong>
            </li>

            <li>
                Keep the original packaging materials and the broken or damaged items.
            </li>

            <li>
                Do not attempt to repair the item(s). Failure to comply with the stated terms and conditions
                may result in claim denial.
            </li>

            <li>
                Your claim will be carefully reviewed. If accepted, a refund covering the declared value of
                the merchandise will be issued within a maximum of <strong class="text-header">6 weeks</strong> from the claim date,
                or an agreement will be reached. The refund for the service cost (packaging and shipping)
                is <strong class="text-header">non-refundable</strong>.
            </li>
        </ol>

        <p>
            Failure to meet these requirements will invalidate the insurance coverage.
            If the steps are not followed, the insurance will not apply.
        </p>

        <p class="insurance-contact">
            <strong class="text-header">Country code:</strong> (52)<br>
            <strong class="text-header">Area code:</strong> (415)<br>
            <strong class="text-header">Phone:</strong> 103-1150<br>
            <strong class="text-header">Mobile:</strong> (415) 103-1150<br>
            <strong class="text-header">Email:</strong> info@tefenvios.com
        </p>
    </div>
</div>



</body>
</html>
