<?= $this->extend('layouts/layout') ?>

<?= $this->section('titulo') ?>Dashboard | TEF Paquetería<?= $this->endSection() ?>

<?= $this->section('contenido') ?>

<div class="container-fluid dashboard-wrapper">

    <!-- KPIs -->
    <div class="row g-4 mb-4">
        <div class="col-xl-3 col-md-6">
            <div class="tef-card kpi-card">
                <div class="d-flex justify-content-between">
                    <div>
                        <div class="kpi-value">128</div>
                        <div class="kpi-label">Envíos activos</div>
                    </div>
                    <div class="kpi-icon"><i class="fas fa-box"></i></div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6">
            <div class="tef-card kpi-card">
                <div class="d-flex justify-content-between">
                    <div>
                        <div class="kpi-value">76</div>
                        <div class="kpi-label">En tránsito</div>
                    </div>
                    <div class="kpi-icon"><i class="fas fa-truck"></i></div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6">
            <div class="tef-card kpi-card">
                <div class="d-flex justify-content-between">
                    <div>
                        <div class="kpi-value">34</div>
                        <div class="kpi-label">Entregados hoy</div>
                    </div>
                    <div class="kpi-icon"><i class="fas fa-check-circle"></i></div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6">
            <div class="tef-card kpi-card">
                <div class="d-flex justify-content-between">
                    <div>
                        <div class="kpi-value">5</div>
                        <div class="kpi-label">Incidencias</div>
                    </div>
                    <div class="kpi-icon"><i class="fas fa-exclamation-triangle"></i></div>
                </div>
            </div>
        </div>
    </div>

    <!-- ACCIONES RÁPIDAS -->
<div class="row g-4 mb-4">
    <div class="col-12">
        <div class="tef-panel">
            <div class="tef-panel-title">Acciones rápidas</div>

            <div class="d-flex flex-wrap gap-3">
                <a href="<?= base_url('crm/contacts/create') ?>"
                   class="tef-btn tef-btn-primary">
                    <i class="fas fa-user-plus me-2"></i>
                    Nuevo contacto
                </a>

                <!-- <a href="<?= base_url('cotizaciones/create') ?>"
                   class="tef-btn tef-btn-secondary">
                    <i class="fas fa-file-invoice-dollar me-2"></i>
                    Nueva cotización
                </a>

                <a href="<?= base_url('empresas/create') ?>"
                   class="tef-btn tef-btn-muted">
                    <i class="fas fa-building me-2"></i>
                    Nueva empresa
                </a> -->
            </div>
        </div>
    </div>
</div>


    <!-- Gráfica + Actividad -->
    <div class="row g-4 mb-4">
        <div class="col-lg-8">
            <div class="tef-panel">
                <div class="tef-panel-title">Envíos por día</div>
                <div style="height:300px;">
                    <canvas id="chartEnvios"></canvas>
                </div>
            </div>
        </div>

        <div class="col-lg-4">
            <div class="tef-panel">
                <div class="tef-panel-title">Actividad reciente</div>
                <ul class="list-unstyled activity-list">
                    <li>📦 Envío <b>#TEF1021</b> creado</li>
                    <li>🚚 Envío <b>#TEF1018</b> en tránsito</li>
                    <li>❗ Incidencia en <b>#TEF1009</b></li>
                    <li>✅ Envío <b>#TEF1001</b> entregado</li>
                </ul>
            </div>
        </div>
    </div>

    <!-- Tabla -->
    <div class="tef-panel">
        <div class="tef-panel-title">Envíos recientes</div>

        <div class="table-responsive tef-table">
            <table class="table table-dark table-hover mb-0">
                <thead>
                    <tr>
                        <th>Folio</th>
                        <th>Cliente</th>
                        <th>Origen</th>
                        <th>Destino</th>
                        <th>Estado</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td>#TEF1021</td>
                        <td>Amazon</td>
                        <td>CDMX</td>
                        <td>Guadalajara</td>
                        <td>
                            <span class="tef-status info">En tránsito</span>
                        </td>
                    </tr>

                    <tr>
                        <td>#TEF1018</td>
                        <td>Mercado Libre</td>
                        <td>Monterrey</td>
                        <td>CDMX</td>
                        <td>
                            <span class="tef-status success">Entregado</span>
                        </td>
                    </tr>

                    <tr>
                        <td>#TEF1009</td>
                        <td>Liverpool</td>
                        <td>Querétaro</td>
                        <td>Puebla</td>
                        <td>
                            <span class="tef-status danger">Incidencia</span>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>

</div>

<?= $this->section('scripts') ?>
<script>
const ctx = document.getElementById('chartEnvios');

new Chart(ctx, {
    type: 'line',
    data: {
        labels: ['Lun','Mar','Mié','Jue','Vie','Sáb','Dom'],
        datasets: [{
            data: [12,19,14,22,18,9,15],
            tension: .4,
            fill: true,
            borderColor: '#caa24d',
            backgroundColor: 'rgba(202,162,77,.2)'
        }]
    },
    options: {
        responsive: true,
        maintainAspectRatio: false,
        plugins: { legend: { display: false } },
        scales: {
            x: { ticks: { color: '#aaa' } },
            y: { ticks: { color: '#aaa' } }
        }
    }
});
</script>
<?= $this->endSection() ?>

<?= $this->endSection() ?>
