<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title><?= $this->renderSection('titulo') ?? 'TEF Paquetería' ?></title>
    <link href="<?= base_url('img/logo-tef.jpg') ?>" rel="icon">

    <!-- Libs -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/css/select2.min.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.4/css/dataTables.bootstrap5.min.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/responsive/2.4.1/css/responsive.bootstrap5.min.css">
    <link href="https://cdn.jsdelivr.net/npm/fullcalendar@6.1.10/index.global.min.css" rel="stylesheet">

    <!-- CSS propios -->
    <link rel="stylesheet" href="<?= base_url('css/tef/tokens.css?v='.time()) ?>">
    <link rel="stylesheet" href="<?= base_url('css/tef/base.css?v='.time()) ?>">
    <link rel="stylesheet" href="<?= base_url('css/tef/components.css?v='.time()) ?>">
    <link rel="stylesheet" href="<?= base_url('css/tef/dashboard.css?v='.time()) ?>">
    <link rel="stylesheet" href="<?= base_url('css/sidemenu.css?v='.time()) ?>">
    <link rel="stylesheet" href="<?= base_url('css/tef/modal.css?v='.time()) ?>">

    <style>
        * {
            box-sizing: border-box;
        }

        body {
            font-family: 'Segoe UI', sans-serif;
            background: radial-gradient(circle at top, #1a1a1a, #000);
            margin: 0;
            color: #eaeaea;
        }

        #layoutWrapper {
            min-height: 100vh;
        }

        #main-content {
            width: 100%;
            overflow-x: hidden;
            background: #0f0f0f;
        }

        #main-content .container,
        #main-content .container-fluid {
            max-width: 100%;
        }

        main {
            border-radius: 16px;
            background: #111;
            box-shadow: 0 0 35px rgba(0,0,0,.6);
        }

        /* Botón menú móvil */
        #toggleSidebarMobile {
            background: linear-gradient(135deg, #caa24d, #e6c87a);
            border: none;
            color: #000;
        }

        /* Ajustes SweetAlert */
        .swal2-popup {
            background: #111 !important;
            color: #fff !important;
        }

        .swal2-title {
            color: #f5f5f5 !important;
        }

        .swal2-confirm {
            background: linear-gradient(135deg, #caa24d, #e6c87a) !important;
            color: #000 !important;
            font-weight: 600;
        }
    </style>

    <?= $this->renderSection('estilos') ?>
</head>

<body>

<?php
$uri = service('uri');
$segmento = $uri->getSegment(1);
?>

<!-- Botón menú móvil -->
<button id="toggleSidebarMobile"
        class="btn d-md-none position-fixed m-2"
        style="z-index:1050;">
    <i class="fas fa-bars"></i>
</button>

<div class="d-flex" id="layoutWrapper">
    <?= $this->include('layouts/sidemenu') ?>

    <main id="main-content" class="flex-grow-1 p-3 w-100">
        <?= $this->renderSection('contenido') ?>
    </main>
</div>

<!-- JS -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.1/dist/chart.umd.min.js"></script>
<script src="https://cdn.datatables.net/1.13.4/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.4/js/dataTables.bootstrap5.min.js"></script>
<script src="https://cdn.datatables.net/responsive/2.4.1/js/dataTables.responsive.min.js"></script>
<script src="https://cdn.datatables.net/responsive/2.4.1/js/responsive.bootstrap5.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.36/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.36/vfs_fonts.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.print.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.colVis.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/fullcalendar@6.1.10/index.global.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/fullcalendar@6.1.10/locales/es.global.min.js"></script>


<script>
    const sidebar = document.getElementById('sidebar');
    const toggleBtn = document.getElementById('toggleSidebarMobile');

    function toggleSidebar() {
        sidebar.classList.toggle('sidebar-mobile-visible');
        sidebar.classList.toggle('sidebar-mobile-hidden');
    }

    toggleBtn?.addEventListener('click', toggleSidebar);

    document.addEventListener('click', function (event) {
        const isMobile = window.innerWidth < 768;
        const isVisible = sidebar?.classList.contains('sidebar-mobile-visible');
        if (isMobile && isVisible && !sidebar.contains(event.target) && !toggleBtn.contains(event.target)) {
            toggleSidebar();
        }
    });
</script>

<?= $this->renderSection('scripts') ?>
</body>
</html>
