<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link href="<?= base_url('img/logo-tef.jpg') ?>" rel="icon">
    <title><?= $this->renderSection('titulo') ?></title>

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" />

    <?= $this->renderSection('styles') ?>

    <style>
        /* PRELOADER */
        #preloader {
            position: fixed;
            inset: 0;
            z-index: 9999;
            background: radial-gradient(circle at center, #1a1a1a, #000);
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .preloader-content {
            text-align: center;
            animation: pulse 1.5s ease-in-out infinite;
        }

        .preloader-content img {
            max-width: 260px;
            filter: drop-shadow(0 0 25px rgba(202,162,77,.35));
        }

        .loading-line {
            margin: 25px auto 0;
            width: 160px;
            height: 3px;
            background: linear-gradient(
                90deg,
                transparent,
                #caa24d,
                #e6c87a,
                #caa24d,
                transparent
            );
            background-size: 200% 100%;
            animation: loading 1.2s linear infinite;
            border-radius: 2px;
        }

        @keyframes pulse {
            0% { transform: scale(0.97); opacity: .85; }
            50% { transform: scale(1); opacity: 1; }
            100% { transform: scale(0.97); opacity: .85; }
        }

        @keyframes loading {
            0% { background-position: 200% 0; }
            100% { background-position: -200% 0; }
        }
    </style>
</head>

<body>

    <!-- PRELOADER -->
    <div id="preloader">
        <div class="preloader-content">
            <img src="<?= base_url('img/logo-tef.png') ?>" alt="TEF Paquetería">
            <div class="loading-line"></div>
        </div>
    </div>

    <?= $this->renderSection('contenido') ?>

    <script src="<?= base_url('js/login/login.js?v=' . time()) ?>"></script>
    <?= $this->renderSection('scripts') ?>

    <script>
        window.addEventListener('load', () => {
            const preloader = document.getElementById('preloader');

            setTimeout(() => {
                preloader.style.opacity = '0';
                preloader.style.transition = 'opacity .6s ease';
                setTimeout(() => preloader.remove(), 600);
            }, 1000);
        });
    </script>

</body>
</html>
