<?php $uri = service('uri'); ?>
<?php
$segment1 = $uri->getSegment(1);
$segment2 = $uri->getSegment(2);

// Función para asignar clase active
function active($cond) {
    return $cond ? 'active' : '';
}

// Función para determinar si un menú colapsable debe abrirse
function show($cond) {
    return $cond ? 'show' : '';
}
?>

<style>
/* ===== MODULOS EN DESARROLLO ===== */
.nav-link.dev-disabled {
    opacity: .55;
    cursor: not-allowed;
    pointer-events: none;
}
.nav-link.dev-enabled {
    pointer-events: auto;
    cursor: pointer;
    opacity: .85;
}
.menu-label .dev-badge {
    margin-left: 6px;
}
.dev-badge {
    font-size: .6rem;
    padding: 2px 6px;
    border-radius: 6px;
    background: #caa24d;
    color: #111;
    font-weight: 700;
    text-transform: uppercase;
}
.submenu.dev-disabled a {
    opacity: .5;
    pointer-events: none;
}
.dev-icon {
    color: #caa24d;
}
/* Chevron rotación cuando abierto */
.nav-link.collapsed > .dev-icon {
    transition: transform 0.2s;
}
.nav-link:not(.collapsed) > .dev-icon {
    transform: rotate(180deg);
}
</style>

<aside id="sidebar" class="sidebar p-3 sidebar-mobile-hidden">
    <div class="sidebar-inner d-flex flex-column h-100">

        <!-- Logo -->
        <div class="text-center mb-4 flex-shrink-0">
            <img src="<?= base_url('img/logo-tef.png') ?>" class="sidebar-logo">
        </div>

        <div class="sidebar-scroll flex-grow-1">
            <ul class="nav flex-column" id="sidebarAccordion">

                <!-- ===== RESUMEN ===== -->
                <li class="nav-item text-uppercase small mt-2 mb-1 menu-label">
                    Resumen
                </li>
                <li class="nav-item mb-2">
                    <a href="<?= base_url('/dashboard') ?>"
                       class="nav-link <?= active($segment1 === 'dashboard') ?>">
                        <i class="fas fa-home me-2"></i> Dashboard
                    </a>
                </li>

                <!-- ===== PLANIFICACIÓN ===== -->
                <li class="nav-item text-uppercase small mt-4 mb-1 menu-label">
                    Planificación
                </li>
                <li class="nav-item mb-2">
                    <a href="<?= base_url('/agenda') ?>"
                       class="nav-link <?= active($segment1 === 'agenda') ?>">
                        <i class="fas fa-calendar-alt me-2"></i> Agenda
                    </a>
                </li>

                <!-- ===== OPERACIONES ===== -->
                <li class="nav-item text-uppercase small mt-4 mb-1 menu-label">
                    Operaciones
                    <span class="dev-badge">En desarrollo</span>
                </li>
                <?php
                    $isShipments = ($segment1 === 'shipments' || ($segment1 === 'crm' && $segment2 === 'orders'));
                ?>
                <li class="nav-item mb-2">
                    <a href="#menuEnvios"
                       data-bs-toggle="collapse"
                       class="nav-link d-flex justify-content-between align-items-center dev-enabled <?= active($isShipments) ?> <?= $isShipments ? '' : 'collapsed' ?>"
                       title="Módulo en desarrollo (funcionalidad parcial)">
                        <span>
                            <i class="fas fa-box me-2"></i> Envíos
                            <span class="dev-badge">Dev</span>
                        </span>
                        <i class="fas fa-chevron-down small dev-icon"></i>
                    </a>

                    <ul class="collapse submenu <?= show($isShipments) ?>"
                        id="menuEnvios"
                        data-bs-parent="#sidebarAccordion">

                        <li>
                            <a href="<?= base_url('shipments') ?>"
                               class="<?= active($segment1 === 'shipments') ?>">
                                Dashboard
                            </a>
                        </li>

                        <li>
                            <a href="<?= base_url('crm/orders') ?>"
                               class="<?= active($segment1 === 'crm' && $segment2 === 'orders') ?>">
                                Ordenes de Envio
                            </a>
                        </li>

                        <li class="dev-disabled">
                            <a>
                                Tracking
                                <span class="dev-badge">Soon</span>
                            </a>
                        </li>
                    </ul>
                </li>

                <!-- ===== CRM ===== -->
                <li class="nav-item text-uppercase small mt-4 mb-1 menu-label">
                    CRM
                </li>
                <?php
                    $isCRM = ($segment1 === 'crm' && !($segment2 === 'orders'));
                ?>
                <li class="nav-item mb-2">
                    <a href="#menuVentas"
                       data-bs-toggle="collapse"
                       class="nav-link d-flex justify-content-between align-items-center <?= active($isCRM) ?> <?= $isCRM ? '' : 'collapsed' ?>">
                        <span><i class="fas fa-file-signature me-2"></i> CRM</span>
                        <i class="fas fa-chevron-down small dev-icon"></i>
                    </a>

                    <ul class="collapse submenu <?= show($isCRM) ?>"
                        id="menuVentas"
                        data-bs-parent="#sidebarAccordion">

                        <li>
                            <a href="<?= base_url('crm/contacts') ?>"
                               class="<?= active($segment1 === 'crm' && $segment2 === 'contacts') ?>">
                                Contactos
                            </a>
                        </li>

                        <li>
                            <a href="<?= base_url('crm/quotes') ?>"
                               class="<?= active($segment1 === 'crm' && $segment2 === 'quotes') ?>">
                                Cotizaciones
                            </a>
                        </li>

                        <li>
                            <a href="<?= site_url('crm/companies') ?>"
                               class="<?= active($segment1 === 'crm' && $segment2 === 'companies') ?>">
                                Empresas
                            </a>
                        </li>
                    </ul>
                </li>

                <!-- ===== FINANZAS ===== -->
                <li class="nav-item text-uppercase small mt-4 mb-1 menu-label">
                    Finanzas
                    <span class="dev-badge">Próximamente</span>
                </li>
                <li class="nav-item mb-2">
                    <a class="nav-link d-flex justify-content-between align-items-center dev-disabled <?= active($segment1 === 'finanzas') ?>">
                        <span>
                            <i class="fas fa-dollar-sign me-2"></i> Finanzas
                        </span>
                        <i class="fas fa-clock dev-icon"></i>
                    </a>
                </li>

                <!-- ===== ADMINISTRACIÓN ===== -->
                <li class="nav-item text-uppercase small mt-4 mb-1 menu-label">
                    Administración
                </li>
                <li class="nav-item mb-2">
                    <a class="nav-link dev-disabled <?= active($segment1 === 'admin') ?>">
                        <i class="fas fa-users me-2"></i>
                        Usuarios
                        <span class="dev-badge">Beta</span>
                    </a>
                </li>

            </ul>
        </div>

        <!-- FOOTER -->
        <div class="sidebar-footer mt-3 flex-shrink-0">

            <div class="alert py-1 px-2 mb-2 text-center fw-bold"
                 style="font-size:.75rem;border-radius:6px;background:#111;color:#caa24d;border:1px solid #222;">
                🚧 Versión de desarrollo
            </div>

            <div class="small border-top pt-3" style="border-color:#222;">
                <div class="d-flex align-items-center p-2 rounded mb-2"
                     style="gap:.75rem;background:#111;border:1px solid #222;">
                    <i class="fas fa-user-circle fa-2x" style="color:#caa24d;"></i>
                    <div class="lh-sm">
                        <div class="fw-semibold text-white">
                            <?= session('nombre') ?>
                        </div>
                        <small style="color:#b5b5b5;">
                            <?= session('email') ?>
                        </small>
                    </div>
                </div>

                <a href="<?= base_url('/logout') ?>"
                   class="btn w-100 text-start"
                   style="border:1px solid #caa24d;color:#caa24d;background:transparent;">
                    <i class="fas fa-sign-out-alt me-2"></i> Cerrar sesión
                </a>
            </div>
        </div>

    </div>
</aside>
