<?= $this->extend('layouts/layout_min') ?>

<?= $this->section('titulo') ?>Login - TEF Paquetería<?= $this->endSection() ?>

<?= $this->section('contenido') ?>


<style>
    body {
        background: #0b0b0b;
    }

    .login-left {
        background: radial-gradient(circle at center, #1a1a1a, #000);
    }

    .login-card {
        background: #111;
        border-radius: 18px;
        padding: 40px;
        box-shadow: 0 0 40px rgba(0,0,0,.6);
    }

    .login-card h2 {
        color: #f5f5f5;
        letter-spacing: 1px;
    }

    .login-card p {
        color: #cfcfcf;
    }

    .form-control {
        background: #1a1a1a;
        border: 1px solid #333;
        color: #fff;
        border-radius: 12px;
    }

    .form-control:focus {
        background: #1a1a1a;
        color: #fff;
        border-color: #caa24d;
        box-shadow: none;
    }

    .btn-tef {
        background: linear-gradient(135deg, #caa24d, #e6c87a);
        color: #000;
        font-weight: 600;
        border-radius: 12px;
    }

    .btn-tef:hover {
        background: linear-gradient(135deg, #e6c87a, #caa24d);
        color: #000;
    }

    .icon {
        color: #caa24d;
    }
</style>

<div class="container-fluid vh-100">
    <div class="row h-100">

        <!-- LADO IZQUIERDO -->
        <div class="col-md-6 d-flex align-items-center justify-content-center login-left">
            <img src="<?= base_url('img/logo-tef.png') ?>" 
                 alt="TEF Paquetería" 
                 class="img-fluid"
                 style="max-width: 65%;">
        </div>

        <!-- LADO DERECHO -->
        <div class="col-md-6 d-flex align-items-center justify-content-center">
            <div class="login-card w-75">

                <h2 class="fw-bold mb-2">Bienvenido</h2>
                <p class="mb-4">Accede al sistema de TEF Paquetería</p>

                <?php if (session()->getFlashdata('error')): ?>
                    <div class="alert alert-danger"><?= session()->getFlashdata('error') ?></div>
                <?php endif; ?>

                <?php if (session()->getFlashdata('success')): ?>
                    <div class="alert alert-success"><?= session()->getFlashdata('success') ?></div>
                <?php endif; ?>

                <?php if (session()->getFlashdata('errors')): ?>
                    <div class="alert alert-danger">
                        <?php foreach (session()->getFlashdata('errors') as $error): ?>
                            <p class="mb-0"><?= esc($error) ?></p>
                        <?php endforeach; ?>
                    </div>
                <?php endif; ?>

                <form action="<?= base_url('login/acceso') ?>" method="post">
                    <?= csrf_field() ?>

                    <div class="mb-3 position-relative">
                        <span class="position-absolute top-50 translate-middle-y ms-3 icon">
                            <i class="fas fa-user"></i>
                        </span>
                        <input type="text"
                               name="usuario"
                               class="form-control ps-5 py-2"
                               placeholder="Correo electrónico"
                               required>
                    </div>

                    <div class="mb-4 position-relative">
                        <span class="position-absolute top-50 translate-middle-y ms-3 icon">
                            <i class="fas fa-lock"></i>
                        </span>
                        <input type="password"
                               name="contrasena"
                               id="passwordInput"
                               class="form-control ps-5 pe-5 py-2"
                               placeholder="Contraseña"
                               required>

                        <span class="position-absolute top-50 end-0 translate-middle-y me-3 icon"
                              style="cursor:pointer"
                              onclick="togglePassword()">
                            <i class="fas fa-eye" id="togglePasswordIcon"></i>
                        </span>
                    </div>

                    <div class="d-grid">
                        <button type="submit" class="btn btn-tef py-2">
                            Iniciar sesión
                        </button>
                    </div>

                </form>
            </div>
        </div>

    </div>
</div>

<script>
function togglePassword() {
    const input = document.getElementById('passwordInput');
    const icon = document.getElementById('togglePasswordIcon');

    if (input.type === "password") {
        input.type = "text";
        icon.classList.replace('fa-eye', 'fa-eye-slash');
    } else {
        input.type = "password";
        icon.classList.replace('fa-eye-slash', 'fa-eye');
    }
}
</script>

<?= $this->endSection() ?>
