<?= $this->extend('layouts/layout') ?>

<?= $this->section('titulo') ?>
Envíos | TEF Paquetería
<?= $this->endSection() ?>

<?= $this->section('estilos') ?>
    <link rel="stylesheet" href="<?= base_url('css/tef/modal.css?v='.time()) ?>">
    <link rel="stylesheet" href="<?= base_url('css/tef/timeline.css?v='.time()) ?>">
<?= $this->endSection() ?>

<?= $this->section('contenido') ?>

<div class="container-fluid py-4">

    <!-- ===== HEADER ===== -->
    <div class="d-flex justify-content-between align-items-start mb-4">
        <div>
            <h3 class="mb-1">Dashboard de Envíos</h3>
            <small class="text-muted">
                Vista general de operaciones · 5 paqueterías
            </small>
        </div>

        <span class="tef-status info">
            🚧 En desarrollo
        </span>
    </div>

    <!-- ===== KPIs ===== -->
    <div class="row g-3 mb-4">

        <div class="col-xl-3 col-md-6">
            <div class="tef-card kpi-card d-flex justify-content-between align-items-center">
                <div>
                    <div class="kpi-label">Total envíos</div>
                    <div class="kpi-value">248</div>
                </div>
                <i class="fas fa-boxes kpi-icon"></i>
            </div>
        </div>

        <div class="col-xl-3 col-md-6">
            <div class="tef-card kpi-card d-flex justify-content-between align-items-center">
                <div>
                    <div class="kpi-label">En tránsito</div>
                    <div class="kpi-value">37</div>
                </div>
                <i class="fas fa-truck-moving kpi-icon"></i>
            </div>
        </div>

        <div class="col-xl-3 col-md-6">
            <div class="tef-card kpi-card d-flex justify-content-between align-items-center">
                <div>
                    <div class="kpi-label">Entregados</div>
                    <div class="kpi-value">198</div>
                </div>
                <i class="fas fa-check-circle kpi-icon"></i>
            </div>
        </div>

        <div class="col-xl-3 col-md-6">
            <div class="tef-card kpi-card d-flex justify-content-between align-items-center">
                <div>
                    <div class="kpi-label">Incidencias</div>
                    <div class="kpi-value">13</div>
                </div>
                <i class="fas fa-exclamation-triangle kpi-icon"></i>
            </div>
        </div>

    </div>

    <!-- ===== GRÁFICA PRINCIPAL ===== -->
    <div class="tef-card mb-4">

        <!-- Header de gráfica -->
        <div class="d-flex justify-content-between align-items-center mb-3">
            <div>
                <h5 class="mb-1">Evolución de envíos</h5>
                <small class="text-muted">Últimos 30 días</small>
            </div>

            <span class="badge rounded-pill"
                style="background:var(--tef-surface-soft);
                        border:1px solid var(--tef-border);
                        color:var(--tef-text-muted);">
                Datos simulados
            </span>
        </div>
        <div style="
            height:300px;
            position:relative;
        ">
            <canvas id="shipmentsChart"></canvas>
        </div>

        <div class="d-flex justify-content-between mt-3 small text-muted">
            <span>Total últimos 30 días: <strong class="text-white">248</strong></span>
            <span>Día más activo: <strong class="text-white">Viernes</strong></span>
            <span>Incidencias promedio: <strong class="text-white">0.4 / día</strong></span>
        </div>

    </div>



    <!-- ===== PAQUETERÍAS ===== -->
    <div class="mb-3">
        <h5 class="mb-0">Performance por paquetería</h5>
        <small class="text-muted">
            Comparativa interna por carrier
        </small>
    </div>

    <div class="row g-3 mb-4">

        <?php
            $carriers = [
                [
                    'name' => 'DHL',
                    'total' => 96,
                    'delivered' => 81,
                    'transit' => 12,
                    'progress' => 84
                ],
                [
                    'name' => 'FedEx',
                    'total' => 74,
                    'delivered' => 62,
                    'transit' => 9,
                    'progress' => 83
                ],
                [
                    'name' => 'Paquetexpress',
                    'total' => 42,
                    'delivered' => 31,
                    'transit' => 7,
                    'progress' => 74
                ],
                [
                    'name' => 'Castores',
                    'total' => 21,
                    'delivered' => 15,
                    'transit' => 5,
                    'progress' => 71
                ],
                [
                    'name' => 'Tres Guerras',
                    'total' => 15,
                    'delivered' => 9,
                    'transit' => 4,
                    'progress' => 60
                ],
            ];
        ?>

        <?php foreach ($carriers as $carrier): ?>
        <div class="col-xl-4 col-md-6">
            <div class="tef-card">
                <div class="d-flex justify-content-between align-items-center mb-2">
                    <strong><?= $carrier['name'] ?></strong>
                    <small class="text-muted"><?= $carrier['total'] ?> envíos</small>
                </div>

                <div class="progress mb-2" style="height:6px;">
                    <div class="progress-bar"
                        style="width:<?= $carrier['progress'] ?>%;background:var(--tef-gold);">
                    </div>
                </div>

                <div class="d-flex justify-content-between small text-muted">
                    <span>Entregados: <?= $carrier['delivered'] ?></span>
                    <span>En tránsito: <?= $carrier['transit'] ?></span>
                </div>
            </div>
        </div>
        <?php endforeach; ?>

    </div>

    <!-- ===== TABLA OPERATIVA ===== -->
    <div class="tef-panel mb-4">
        <div class="tef-panel-title">
            Envíos recientes
        </div>

        <div class="text-muted small mb-3">
            Vista operativa para seguimiento diario
        </div>
        <div class="tef-table-responsive">
            <table class="c-table">
                <thead>
                    <tr class="text-muted small">
                        <th>Guía</th>
                        <th>Paquetería</th>
                        <th>Estado</th>
                        <th>Último evento</th>
                        <th>Acción</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td data-label="Guía">6100050512345</td>
                        <td data-label="Paquetería">DHL</td>
                        <td data-label="Estado">
                            <span class="tef-status success">Entregado</span>
                        </td>
                        <td data-label="Último evento">Henderson, NV</td>
                        <td data-label="Acción">
                            <a href="#"
                            class="tef-btn tef-btn-muted btn-sm js-open-shipment"
                            data-guia="6100050512345"
                            data-carrier="DHL"
                            data-status="Entregado">
                                Ver
                            </a>
                        </td>
                    </tr>


                    <tr>
                        <td data-label="Guía">785412369852</td>
                        <td data-label="Paquetería">FedEx</td>
                        <td data-label="Estado">
                            <span class="tef-status info">En tránsito</span>
                        </td>
                        <td data-label="Último evento">Memphis, TN</td>
                        <td data-label="Acción">
                            <a href="#"
                                class="tef-btn tef-btn-muted btn-sm js-open-shipment"
                                data-guia="785412369852"
                                data-carrier="FedEx"
                                data-status="En tránsito">
                                    Ver
                            </a>
                        </td>
                    </tr>

                    <tr>
                        <td data-label="Guía">CAST-458721</td>
                        <td data-label="Paquetería">Castores</td>
                        <td data-label="Estado">
                            <span class="tef-status danger">Incidencia</span>
                        </td>
                        <td data-label="Último evento">Monterrey, NL</td>
                        <td data-label="Acción">
                            <a href="#"
                                class="tef-btn tef-btn-muted btn-sm js-open-shipment"
                                data-guia="CAST-458721"
                                data-carrier="Castores"
                                data-status="Incidencia">
                                    Ver
                            </a>
                        </td>
                    </tr>
                    </tbody>
            </table>
        </div>
    </div>

    <!-- ===== FOOTER INFO ===== -->
    <div class="alert small"
         style="background:var(--tef-surface-soft);border:1px dashed var(--tef-border);color:var(--tef-text-muted);">
        📌 Este módulo se encuentra en fase visual.  
        La información se conectará a las APIs de Castores, Paquetexpress, DHL, FedEx y Tres Guerras.
    </div>

</div>

<div class="tef-modal-overlay" id="shipmentModal">

    <div class="tef-modal tef-modal-lg">

        <div class="tef-modal-header">
            <div class="tef-modal-title">
                Detalle del envío
            </div>
            <button class="tef-modal-close" data-close-modal>
                ✕
            </button>
        </div>

        <div class="tef-modal-body">

            <div class="tef-card">
                <strong>Guía:</strong> <span id="modalGuide">—</span><br>
                <strong>Paquetería:</strong> <span id="modalCarrier">—</span>
            </div>

            <div class="tef-card">
                <div class="kpi-label">Último evento</div>
                <div class="kpi-value" id="modalStatus">—</div>
            </div>

            <div class="tef-timeline">

                <div class="tef-timeline-item success">
                    <div class="tef-timeline-dot"></div>
                    <div class="tef-timeline-content">
                        <div class="tef-timeline-title">
                            Entregado
                        </div>
                        <div class="tef-timeline-meta">
                            15 Ene 2026 · 13:42 · Guadalajara, JAL
                        </div>
                    </div>
                </div>

                <div class="tef-timeline-item info">
                    <div class="tef-timeline-dot"></div>
                    <div class="tef-timeline-content">
                        <div class="tef-timeline-title">
                            En ruta de entrega
                        </div>
                        <div class="tef-timeline-meta">
                            15 Ene 2026 · 08:11 · Centro de distribución
                        </div>
                    </div>
                </div>

                <div class="tef-timeline-item info">
                    <div class="tef-timeline-dot"></div>
                    <div class="tef-timeline-content">
                        <div class="tef-timeline-title">
                            Salida de sucursal
                        </div>
                        <div class="tef-timeline-meta">
                            14 Ene 2026 · 22:36 · Monterrey, NL
                        </div>
                    </div>
                </div>

                <div class="tef-timeline-item">
                    <div class="tef-timeline-dot"></div>
                    <div class="tef-timeline-content">
                        <div class="tef-timeline-title">
                            Información recibida
                        </div>
                        <div class="tef-timeline-meta">
                            13 Ene 2026 · 10:05 · Envío creado
                        </div>
                    </div>
                </div>

            </div>


        </div>

        <div class="tef-modal-footer">
            <button class="tef-btn tef-btn-muted" data-close-modal>
                Cerrar
            </button>
        </div>

    </div>

</div>


<?= $this->endSection() ?>

<?= $this->section('scripts') ?>

<script>
const ctx = document.getElementById('shipmentsChart');

new Chart(ctx, {
    type: 'line',
    data: {
        labels: [
            '01','02','03','04','05','06','07','08','09','10',
            '11','12','13','14','15','16','17','18','19','20',
            '21','22','23','24','25','26','27','28','29','30'
        ],
        datasets: [
            {
                label: 'Entregados',
                data: [5,6,8,7,9,10,8,7,9,11,10,9,8,7,9,10,11,9,8,10,12,11,10,9,8,9,10,11,12,13],
                borderColor: '#CAA24D',
                backgroundColor: 'rgba(202,162,77,.25)',
                fill: true,
                tension: .4
            },
            {
                label: 'En tránsito',
                data: [2,3,2,4,3,2,3,4,3,2,3,4,3,2,3,4,3,2,3,4,3,2,3,4,3,2,3,4,3,2],
                borderColor: '#4DA3FF',
                backgroundColor: 'rgba(77,163,255,.15)',
                fill: true,
                tension: .4
            },
            {
                label: 'Incidencias',
                data: [0,1,0,1,0,0,1,0,1,0,1,0,0,1,0,1,0,1,0,1,0,0,1,0,1,0,1,0,0,1],
                borderColor: '#FF5C5C',
                backgroundColor: 'rgba(255,92,92,.2)',
                fill: true,
                tension: .4
            }
        ]
    },
    options: {
        responsive: true,
        maintainAspectRatio: false,
        plugins: {
            legend: {
                labels: {
                    color: '#9CA3AF'
                }
            },
            tooltip: {
                mode: 'index',
                intersect: false
            }
        },
        scales: {
            x: {
                ticks: { color: '#6B7280' },
                grid: { color: 'rgba(255,255,255,.04)' }
            },
            y: {
                ticks: { color: '#6B7280' },
                grid: { color: 'rgba(255,255,255,.04)' }
            }
        }
    }
});
</script>
<script>
const modal = document.getElementById('shipmentModal');

/* ABRIR MODAL */
document.querySelectorAll('.js-open-shipment').forEach(btn => {
    btn.addEventListener('click', (e) => {
        e.preventDefault(); // 👈 importante

        document.getElementById('modalGuide').textContent = btn.dataset.guia;
        document.getElementById('modalCarrier').textContent = btn.dataset.carrier;
        document.getElementById('modalStatus').textContent = btn.dataset.status;

        modal.classList.add('is-open');
    });
});

/* CERRAR MODAL */
document.querySelectorAll('[data-close-modal]').forEach(btn => {
    btn.addEventListener('click', () => {
        modal.classList.remove('is-open');
    });
});
</script>



<?= $this->endSection() ?>
